/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.integration.cloudsdk.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.feature.platform.PlatformEnvironment;
import com.sap.cds.feature.platform.ServiceBinding;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"ApplicationLifecycleService$Default"})
public class CloudplatformEnvironmentHandler
implements EventHandler {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(CloudplatformEnvironmentHandler.class);

    @Before(event={"APPLICATION_LIFECYCLE_PREPARED"})
    public void registerEnvironmentHandler() {
        CloudPlatformAccessor.tryGetCloudPlatform().andThen(platform -> platform.setEnvironmentVariableReader((Function)new CdsEnvironmentVariableReader(PlatformEnvironment.INSTANCE)));
    }

    static class CdsEnvironmentVariableReader
    implements Function<String, String> {
        private String vcapServices = null;

        public CdsEnvironmentVariableReader(PlatformEnvironment platformEnvironment) {
            List bindings = platformEnvironment.getServiceBindings().collect(Collectors.toList());
            HashMap<String, ArrayList<ServiceBinding>> serviceToBinding = new HashMap<String, ArrayList<ServiceBinding>>();
            for (ServiceBinding binding : bindings) {
                ArrayList<ServiceBinding> service = (ArrayList<ServiceBinding>)serviceToBinding.get(binding.getService());
                if (service == null) {
                    service = new ArrayList<ServiceBinding>();
                    serviceToBinding.put(binding.getService(), service);
                }
                service.add(binding);
            }
            try {
                this.vcapServices = mapper.writeValueAsString(serviceToBinding);
            }
            catch (JsonProcessingException e) {
                logger.warn("Could not serialize service bindings to JSON", (Throwable)e);
            }
        }

        @Override
        public String apply(String name) {
            if (name.equals("VCAP_SERVICES")) {
                return this.vcapServices;
            }
            return System.getenv(name);
        }
    }
}

