/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.integration.cloudsdk.provider;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.sap.cds.services.utils.CorrelationIdUtils;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationHeaderProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationRequestContext;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;

/**
 * Custom destination header provider which propagates any correlation id
 * header.
 * 
 * Checks for both "X-Correlation-Id" and "X-CorrelationID" header names.
 */
public class CorrelationIdHeaderProvider implements DestinationHeaderProvider {

	@Override
	public List<Header> getHeaders(DestinationRequestContext requestContext) {
		String correlationID = CorrelationIdUtils.getCorrelationId(null);
		List<Header> headers = new ArrayList<>();
		if (!StringUtils.isEmpty(correlationID)) {
			headers.add(new Header(CorrelationIdUtils.CORRELATION_ID_HEADER_KEY, correlationID));
		}
		return headers;
	}
}