/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.integration.cloudsdk.destination;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.destination.XsuaaOAuth2PropertySupplier;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.client.HttpClient;

public class RemoteServiceHttpClientProvider {
    private static Map<Pair<String, OnBehalfOf>, HttpDestination> destinations;

    private RemoteServiceHttpClientProvider() {
    }

    public static HttpClient getHttpClient(CdsProperties.Remote.RemoteServiceConfig remoteServiceConfig, CdsRuntime runtime) {
        if (StringUtils.isEmpty((String)remoteServiceConfig.getDestination().getName())) {
            remoteServiceConfig.getDestination().setName(remoteServiceConfig.getName());
        }
        return HttpClientAccessor.getHttpClient((HttpDestinationProperties)RemoteServiceHttpClientProvider.initHttpDestination(remoteServiceConfig, runtime));
    }

    @VisibleForTesting
    static HttpDestination initHttpDestination(CdsProperties.Remote.RemoteServiceConfig remoteServiceConfig, CdsRuntime runtime) {
        if (!remoteServiceConfig.getDestination().getProperties().isEmpty()) {
            DefaultHttpDestination.Builder builder = new DefaultHttpDestination.Builder();
            remoteServiceConfig.getDestination().getProperties().forEach((arg_0, arg_1) -> ((DefaultHttpDestination.Builder)builder).property(arg_0, arg_1));
            return builder.build();
        }
        if (!StringUtils.isEmpty((String)remoteServiceConfig.getBinding().getName())) {
            CdsProperties.Remote.RemoteServiceConfig.Binding binding = remoteServiceConfig.getBinding();
            String onBehalfOf = binding.getOnBehalfOf();
            UserInfo userInfo = RequestContext.getCurrent((CdsRuntime)runtime).getUserInfo();
            OnBehalfOf effectiveOnBehalf = "currentUser".equals(onBehalfOf) && userInfo.isAuthenticated() && !userInfo.isSystemUser() ? OnBehalfOf.NAMED_USER_CURRENT_TENANT : ("systemUserProvider".equals(onBehalfOf) ? OnBehalfOf.TECHNICAL_USER_PROVIDER : OnBehalfOf.TECHNICAL_USER_CURRENT_TENANT);
            Pair key = Pair.of((Object)remoteServiceConfig.getName(), (Object)effectiveOnBehalf);
            return destinations.computeIfAbsent((Pair<String, OnBehalfOf>)key, k -> RemoteServiceHttpClientProvider.initServiceBindingBasedDestination(binding, effectiveOnBehalf, runtime));
        }
        CdsProperties.Remote.RemoteServiceConfig.Destination destination = remoteServiceConfig.getDestination();
        DestinationOptions.Builder builder = DestinationOptions.builder();
        if (!StringUtils.isEmpty((String)destination.getRetrievalStrategy())) {
            builder.parameter("dwc.destinationRetrievalStrategy", (Object)destination.getRetrievalStrategy());
            builder.parameter("scp.cf.destinationRetrievalStrategy", (Object)destination.getRetrievalStrategy());
        }
        if (!StringUtils.isEmpty((String)destination.getTokenExchangeStrategy())) {
            builder.parameter("scp.cf.destinationTokenExchangeStrategy", (Object)destination.getTokenExchangeStrategy());
        }
        return ((Destination)DestinationAccessor.getLoader().tryGetDestination(destination.getName(), builder.build()).getOrElseThrow(failure -> {
            if (failure instanceof DestinationAccessException) {
                DestinationAccessException daex = (DestinationAccessException)failure;
                throw daex;
            }
            throw new DestinationAccessException("Failed to get destination with name '" + destination.getName() + "'.", failure);
        })).asHttp();
    }

    private static HttpDestination initServiceBindingBasedDestination(CdsProperties.Remote.RemoteServiceConfig.Binding binding, OnBehalfOf onBehalfOf, CdsRuntime runtime) {
        ServiceBinding serviceBinding = runtime.getEnvironment().getServiceBindings().filter(b -> ((String)b.getName().get()).equals(binding.getName())).findFirst().orElse(null);
        String url = (String)binding.getOptions().get("url");
        return ServiceBindingDestinationLoader.defaultLoaderChain().getDestination(ServiceBindingDestinationOptions.forService((ServiceBinding)serviceBinding).withOption((ServiceBindingDestinationOptions.OptionsEnhancer)new XsuaaOAuth2PropertySupplier.UrlOptions(url)).onBehalfOf(onBehalfOf).build());
    }

    static {
        XsuaaOAuth2PropertySupplier.initialize();
        destinations = new ConcurrentHashMap<Pair<String, OnBehalfOf>, HttpDestination>();
    }
}

