/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.integration.cloudsdk.facade;

import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cloud.sdk.cloudplatform.security.principal.DefaultPrincipal;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalFacade;

import io.vavr.control.Try;

public class CdsPrincipalFacade implements PrincipalFacade {

	private final CdsRuntime runtime;

	public CdsPrincipalFacade(CdsRuntime runtime) {
		this.runtime = runtime;
	}

	@Override
	public Try<Principal> tryGetCurrentPrincipal() {
		String principalId = RequestContext.getCurrent(runtime).getUserInfo().getName();
		return Try.success(new DefaultPrincipal(principalId));
	}

}
