/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.integration.cloudsdk.handler;

import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.DependenciesEventContext;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"DeploymentService$Default"})
public class DestinationServiceMtHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(DestinationServiceMtHandler.class);
    private static final String DESTINATION = "destination";
    private String xsappname;
    private String bindingName;

    public DestinationServiceMtHandler(Stream<ServiceBinding> bindings) {
        Optional<ServiceBinding> binding = bindings.filter(b -> ServiceBindingUtils.matches((ServiceBinding)b, (String)DESTINATION)).findFirst();
        if (binding.isPresent()) {
            this.bindingName = binding.get().getName().orElse("");
            Map credentials = binding.get().getCredentials();
            this.xsappname = (String)credentials.get("xsappname");
        }
    }

    @After
    public void addDestinationDependency(DependenciesEventContext context) {
        if (this.xsappname == null) {
            return;
        }
        logger.debug("Providing Destination service dependency for binding '{}' with xsappname '{}'", (Object)this.bindingName, (Object)this.xsappname);
        context.getResult().add(Collections.singletonMap("xsappname", this.xsappname));
    }
}

