package com.sap.cds.integration.cloudsdk.destination;


import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.IdentityUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.sdk.cloudplatform.connectivity.BtpServiceOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;

public class IasDestinationUtils {

	public static final String IAS_DEPENDENCY_NAME = "cloudsdk.ias-dependency-name";

	public static boolean isIasDestination(HttpDestination httpDestination) {
		return httpDestination.get(IAS_DEPENDENCY_NAME).isDefined();
	}

	public static ServiceBinding resolveIasBinding(CdsRuntime runtime) {
		return new IdentityUtils(runtime).getIasServiceBindings().stream().findFirst().orElseThrow(() -> new ErrorStatusException(CdsErrorStatuses.NO_SERVICE_BINDING, "IAS"));
	}

	public static void enhanceOptions(ServiceBindingDestinationOptions.Builder builder, HttpDestination destination) {
		builder.withOption(BtpServiceOptions.IasOptions.withApplicationName((String)destination.get(IAS_DEPENDENCY_NAME).get()));
		builder.withOption(BtpServiceOptions.AuthenticationServiceOptions.withTargetUri(destination.getUri()));
	}
}
