/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.integration.cloudsdk.destination;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.integration.cloudsdk.destination.IasDestinationUtils;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.sdk.cloudplatform.connectivity.BtpServiceOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.client.HttpClient;

public class RemoteServiceHttpClientProvider {
    private static Map<Pair<Object, OnBehalfOf>, HttpDestination> destinations = new ConcurrentHashMap<Pair<Object, OnBehalfOf>, HttpDestination>();

    private RemoteServiceHttpClientProvider() {
    }

    public static HttpClient getHttpClient(CdsProperties.Remote.RemoteServiceConfig remoteServiceConfig, CdsRuntime runtime) {
        if (StringUtils.isEmpty((String)remoteServiceConfig.getDestination().getName())) {
            remoteServiceConfig.getDestination().setName(remoteServiceConfig.getName());
        }
        return HttpClientAccessor.getHttpClient((HttpDestinationProperties)RemoteServiceHttpClientProvider.initHttpDestination(remoteServiceConfig, runtime));
    }

    @VisibleForTesting
    static HttpDestination initHttpDestination(CdsProperties.Remote.RemoteServiceConfig remoteServiceConfig, CdsRuntime runtime) {
        HttpDestination httpDestination;
        if (!remoteServiceConfig.getDestination().getProperties().isEmpty()) {
            return DefaultHttpDestination.fromMap((Map)remoteServiceConfig.getDestination().getProperties()).build();
        }
        if (!StringUtils.isEmpty((String)remoteServiceConfig.getBinding().getName())) {
            String name = remoteServiceConfig.getName();
            CdsProperties.Remote.RemoteServiceConfig.Binding binding = remoteServiceConfig.getBinding();
            String onBehalfOf = binding.getOnBehalfOf();
            Supplier<ServiceBinding> serviceBindingProvider = () -> runtime.getEnvironment().getServiceBindings().filter(b -> ((String)b.getName().get()).equals(binding.getName())).findFirst().orElse(null);
            return RemoteServiceHttpClientProvider.retrieveOrInitBindingBasedDestination(name, onBehalfOf, serviceBindingProvider, runtime, b -> {
                String url = (String)binding.getOptions().get("url");
                if (url != null) {
                    b.withOption(BtpServiceOptions.AuthenticationServiceOptions.withTargetUri((String)url));
                }
            });
        }
        CdsProperties.Remote.RemoteServiceConfig.Destination destination = remoteServiceConfig.getDestination();
        DestinationOptions.Builder builder = DestinationOptions.builder();
        if (!StringUtils.isEmpty((String)destination.getRetrievalStrategy())) {
            builder.parameter("dwc.destinationRetrievalStrategy", (Object)destination.getRetrievalStrategy());
            builder.parameter("scp.cf.destinationRetrievalStrategy", (Object)destination.getRetrievalStrategy());
        }
        if (!StringUtils.isEmpty((String)destination.getTokenExchangeStrategy())) {
            builder.parameter("scp.cf.destinationTokenExchangeStrategy", (Object)destination.getTokenExchangeStrategy());
        }
        if (IasDestinationUtils.isIasDestination(httpDestination = ((Destination)DestinationAccessor.getLoader().tryGetDestination(destination.getName(), builder.build()).getOrElseThrow(failure -> {
            if (failure instanceof DestinationAccessException) {
                DestinationAccessException daex = (DestinationAccessException)((Object)failure);
                throw daex;
            }
            throw new DestinationAccessException("Failed to get destination with name '" + destination.getName() + "'.", failure);
        })).asHttp())) {
            Supplier<ServiceBinding> bindingProvider = () -> IasDestinationUtils.resolveIasBinding(runtime);
            return RemoteServiceHttpClientProvider.retrieveOrInitBindingBasedDestination(httpDestination, "currentUser", bindingProvider, runtime, b -> IasDestinationUtils.enhanceOptions(b, httpDestination));
        }
        return httpDestination;
    }

    private static HttpDestination retrieveOrInitBindingBasedDestination(Object key, String onBehalfOf, Supplier<ServiceBinding> bindingProvider, CdsRuntime runtime, Consumer<ServiceBindingDestinationOptions.Builder> consumer) {
        UserInfo userInfo = RequestContext.getCurrent((CdsRuntime)runtime).getUserInfo();
        OnBehalfOf effectiveOnBehalf = "currentUser".equals(onBehalfOf) && userInfo.isAuthenticated() && !userInfo.isSystemUser() ? OnBehalfOf.NAMED_USER_CURRENT_TENANT : ("systemUserProvider".equals(onBehalfOf) ? OnBehalfOf.TECHNICAL_USER_PROVIDER : OnBehalfOf.TECHNICAL_USER_CURRENT_TENANT);
        Pair cacheKey = Pair.of((Object)key, (Object)effectiveOnBehalf);
        return destinations.computeIfAbsent((Pair<Object, OnBehalfOf>)cacheKey, k -> {
            ServiceBindingDestinationOptions.Builder builder = ServiceBindingDestinationOptions.forService((ServiceBinding)((ServiceBinding)bindingProvider.get())).onBehalfOf(effectiveOnBehalf);
            consumer.accept(builder);
            return ServiceBindingDestinationLoader.defaultLoaderChain().getDestination(builder.build());
        });
    }
}

