/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.integration.cloudsdk.handler;

import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;

public class CloudSdkHandlerConfiguration implements CdsRuntimeConfiguration {

	@Override
	public void eventHandlers(CdsRuntimeConfigurer configurer) {
		configurer.eventHandler(new FacadeRegistrationHandler())
			.eventHandler(new ThreadContextHandler());

		boolean createDependency = configurer.getCdsRuntime().getEnvironment().getCdsProperties().getMultiTenancy().getDependencies().isDestination();

		if (createDependency) {
			configurer.eventHandler(new DestinationServiceMtHandler(configurer.getCdsRuntime().getEnvironment().getServiceBindings()));
		}
	}
}
