/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.integration.cloudsdk.rest.client;

import java.io.IOException;

@SuppressWarnings("serial")
public class JsonRestClientResponseException extends IOException {

	int responseCode;

	public JsonRestClientResponseException(int code, String message, Throwable cause) {
		super(message, cause);
		this.responseCode = code;
	}

	public JsonRestClientResponseException(int code, String message) {
		super(message);
		this.responseCode = code;
	}

	public int getResponseCode() {
		return responseCode;
	}
}
