/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.integration.cloudsdk.handler;

import com.sap.cds.integration.cloudsdk.decorator.CdsThreadContextDecorator;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cloud.sdk.cloudplatform.thread.DefaultThreadContextDecoratorChain;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"ApplicationLifecycleService$Default"})
public class ThreadContextHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(ThreadContextHandler.class);

    @Before
    public void registerDecorators(ApplicationPreparedEventContext context) {
        if (context.getCdsRuntime().getEnvironment().getCdsProperties().getCloudSdk().getExecutorDecorator().isEnabled().booleanValue()) {
            logger.debug("Adding {} to Cloud SDK executor service", (Object)CdsThreadContextDecorator.class.getSimpleName());
            this.registerThreadContextDecorator(context);
        }
    }

    private void registerThreadContextDecorator(ApplicationPreparedEventContext context) {
        DefaultThreadContextDecoratorChain.registerDefaultDecorator((ThreadContextDecorator)new CdsThreadContextDecorator(context.getCdsRuntime()));
    }
}

