/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.integration.cloudsdk.handler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cds.integration.cloudsdk.decorator.CdsThreadContextDecorator;
import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cloud.sdk.cloudplatform.thread.DefaultThreadContextDecoratorChain;

@ServiceName(ApplicationLifecycleService.DEFAULT_NAME)
public class ThreadContextHandler implements EventHandler {

	private static final Logger logger = LoggerFactory.getLogger(ThreadContextHandler.class);

	@Before
	public void registerDecorators(ApplicationPreparedEventContext context) {
		if(context.getCdsRuntime().getEnvironment().getCdsProperties().getCloudSdk().getExecutorDecorator().isEnabled()) {
			logger.debug("Adding {} to Cloud SDK executor service", CdsThreadContextDecorator.class.getSimpleName());
			registerThreadContextDecorator(context);
		}
	}

	private void registerThreadContextDecorator(ApplicationPreparedEventContext context) {
		DefaultThreadContextDecoratorChain.registerDefaultDecorator(new CdsThreadContextDecorator(context.getCdsRuntime()));
	}
}
