/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.integration.cloudsdk.facade;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cloud.sdk.cloudplatform.tenant.DefaultTenant;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantFacade;
import io.vavr.control.Try;
import java.net.URI;

public class CdsTenantFacade
implements TenantFacade {
    private final CdsRuntime runtime;

    public CdsTenantFacade(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public Try<Tenant> tryGetCurrentTenant() {
        UserInfo userInfo = RequestContext.getCurrent((CdsRuntime)this.runtime).getUserInfo();
        String tenantId = userInfo.getTenant();
        if (tenantId == null) {
            return Try.failure((Throwable)new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TENANT_CONTEXT_MISSING, new Object[0]));
        }
        String subdomain = IdentityTenant.getSubdomain(userInfo);
        IdentityTenant tenant = subdomain != null ? new IdentityTenant(tenantId, subdomain) : new DefaultTenant(tenantId);
        return Try.success((Object)((Object)tenant));
    }

    private static class IdentityTenant
    extends DefaultTenant {
        private final String subdomain;

        private static String getSubdomain(UserInfo userInfo) {
            String subDomain = (String)userInfo.getAdditionalAttribute("subDomain");
            if (!StringUtils.isEmpty((String)subDomain)) {
                return subDomain;
            }
            Object issuer = userInfo.getAdditionalAttribute("iss");
            if (issuer != null) {
                try {
                    int subdomainEnd;
                    String host = URI.create(issuer.toString()).getHost();
                    if (host != null && (subdomainEnd = host.indexOf(46)) > 0) {
                        return host.substring(0, subdomainEnd);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return null;
        }

        public IdentityTenant(String tenant, String subdomain) {
            super(tenant);
            this.subdomain = subdomain;
        }

        public String getSubdomain() {
            return this.subdomain;
        }
    }
}

