/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.integration.cloudsdk.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.integration.cloudsdk.destination.HttpClientProvider;
import com.sap.cds.integration.cloudsdk.rest.client.JsonRestClientResponseException;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceRuntimeException;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestDeniedException;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRestClient {
    private static final Logger logger = LoggerFactory.getLogger(JsonRestClient.class);
    private static final String JSON_CONTENT = "application/json";
    private static final String CONTENT_TYPE = "content-type";
    protected final ObjectMapper mapper = new ObjectMapper();
    private final Supplier<HttpClient> clientProvider;

    public JsonRestClient(ServiceBindingDestinationOptions options) {
        this(options, new CdsProperties.ConnectionPool(Duration.ofSeconds(60L), Integer.valueOf(2), Integer.valueOf(20)));
    }

    public JsonRestClient(ServiceBindingDestinationOptions options, CdsProperties.ConnectionPool connectionPool) {
        this.clientProvider = new HttpClientProvider(ServiceBindingDestinationLoader.defaultLoaderChain().getDestination(options), connectionPool, null);
    }

    public JsonRestClient(String destinationName, String retrievalStrategy) {
        this.clientProvider = () -> {
            HttpDestination destination = ((Destination)DestinationAccessor.getLoader().tryGetDestination(destinationName, DestinationOptions.builder().parameter("scp.cf.destinationRetrievalStrategy", (Object)retrievalStrategy).build()).getOrElseThrow(failure -> {
                if (failure instanceof DestinationAccessException) {
                    DestinationAccessException daex = (DestinationAccessException)failure;
                    throw daex;
                }
                throw new DestinationAccessException("Failed to get destination with name '" + destinationName + "'.", failure);
            })).asHttp();
            return HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode getRequest(String path) throws IOException {
        HttpGet get = new HttpGet(path);
        try {
            JsonNode jsonNode = this.handleJsonResponse(this.handleRequest((HttpRequestBase)get));
            return jsonNode;
        }
        finally {
            get.releaseConnection();
        }
    }

    public int getRequestWithOnlyResponseCode(String path) throws IOException {
        HttpGet get = new HttpGet(path);
        try {
            int n;
            block9: {
                CloseableHttpResponse response = this.handleRequest((HttpRequestBase)get);
                try {
                    n = response.getStatusLine().getStatusCode();
                    if (response == null) break block9;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return n;
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode deleteRequest(String path) throws IOException {
        HttpDelete del = new HttpDelete(path);
        try {
            JsonNode jsonNode = this.handleJsonResponse(this.handleRequest((HttpRequestBase)del));
            return jsonNode;
        }
        finally {
            del.releaseConnection();
        }
    }

    public int putRequestWithOnlyResponseCode(String path, JsonNode data) throws IOException {
        HttpPut put = new HttpPut(path);
        if (data != null) {
            put.setEntity((HttpEntity)new StringEntity(this.mapper.writer().writeValueAsString((Object)data), ContentType.APPLICATION_JSON));
        }
        try {
            int n;
            block11: {
                CloseableHttpResponse response = this.handleRequest((HttpRequestBase)put);
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    int code = response.getStatusLine().getStatusCode();
                    if (code < 200 || code > 207) {
                        String reason = response.getStatusLine().getReasonPhrase();
                        throw new JsonRestClientResponseException(code, "Unexpected request HTTP response (" + code + ") " + reason);
                    }
                    n = response.getStatusLine().getStatusCode();
                    if (response == null) break block11;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return n;
        }
        finally {
            put.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode putRequest(String path, JsonNode data) throws IOException {
        HttpPut put = new HttpPut(path);
        if (data != null) {
            put.setEntity((HttpEntity)new StringEntity(this.mapper.writer().writeValueAsString((Object)data), ContentType.APPLICATION_JSON));
        }
        try {
            JsonNode jsonNode = this.handleJsonResponse(this.handleRequest((HttpRequestBase)put));
            return jsonNode;
        }
        finally {
            put.releaseConnection();
        }
    }

    public JsonNode postRequest(String path, JsonNode data) throws IOException {
        String strData = this.mapper.writer().writeValueAsString((Object)data);
        return this.postRequest(path, strData, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode postRequest(String path, String data, Map<String, Object> headers) throws IOException {
        HttpPost post = new HttpPost(path);
        if (headers != null) {
            headers.forEach((k, v) -> post.setHeader(k, v.toString()));
        }
        if (data != null) {
            post.setEntity((HttpEntity)new StringEntity(data, ContentType.APPLICATION_JSON));
        }
        try {
            JsonNode jsonNode = this.handleJsonResponse(this.handleRequest((HttpRequestBase)post));
            return jsonNode;
        }
        finally {
            post.releaseConnection();
        }
    }

    public int patchRequestWithOnlyResponseCode(String path, JsonNode data) throws IOException {
        HttpPatch put = new HttpPatch(path);
        if (data != null) {
            put.setEntity((HttpEntity)new StringEntity(this.mapper.writer().writeValueAsString((Object)data), ContentType.APPLICATION_JSON));
        }
        try {
            int n;
            block11: {
                CloseableHttpResponse response = this.handleRequest((HttpRequestBase)put);
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    int code = response.getStatusLine().getStatusCode();
                    if (code < 200 || code > 207) {
                        String reason = response.getStatusLine().getReasonPhrase();
                        throw new JsonRestClientResponseException(code, "Unexpected request HTTP response (" + code + ") " + reason);
                    }
                    n = response.getStatusLine().getStatusCode();
                    if (response == null) break block11;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return n;
        }
        finally {
            put.releaseConnection();
        }
    }

    private CloseableHttpResponse handleRequest(HttpRequestBase request) throws IOException {
        this.setHeaders((HttpRequest)request);
        try {
            return ((CloseableHttpClient)this.clientProvider.get()).execute((HttpUriRequest)request);
        }
        catch (DestinationAccessException | ResilienceRuntimeException | TokenRequestDeniedException | TokenRequestFailedException e) {
            if (ExceptionUtils.indexOfThrowable((Throwable)e, TokenRequestDeniedException.class) >= 0) {
                throw new JsonRestClientResponseException(401, "Authentication invalid: " + e.getMessage());
            }
            if (ExceptionUtils.indexOfThrowable((Throwable)e, TokenRequestFailedException.class) >= 0) {
                throw new JsonRestClientResponseException(401, "Authentication failed: " + e.getMessage());
            }
            throw e;
        }
    }

    private void setHeaders(HttpRequest request) {
        logger.debug("Creating {} request to {}", (Object)request.getRequestLine().getMethod(), (Object)request.getRequestLine().getUri());
        request.removeHeaders(CONTENT_TYPE);
        request.addHeader(CONTENT_TYPE, JSON_CONTENT);
    }

    private JsonNode handleJsonResponse(CloseableHttpResponse response) throws IOException {
        try (CloseableHttpResponse resp = response;){
            int code = resp.getStatusLine().getStatusCode();
            logger.debug("Responded with status code '{}'", (Object)code);
            if (code >= 200 && code <= 207) {
                String contentType = JSON_CONTENT;
                if (resp.getEntity() != null) {
                    if (resp.getEntity().getContentType() != null) {
                        contentType = resp.getEntity().getContentType().getValue();
                    }
                    if (contentType.contains(JSON_CONTENT)) {
                        String jsonData = EntityUtils.toString((HttpEntity)resp.getEntity());
                        JsonNode jsonNode = (JsonNode)this.mapper.readValue(jsonData, JsonNode.class);
                        return jsonNode;
                    }
                    throw new IOException("Unexpected response format: Expected JSON but found '" + contentType + "'");
                }
                JsonNode jsonNode = (JsonNode)this.mapper.readValue("{}", JsonNode.class);
                return jsonNode;
            }
            String reason = resp.getStatusLine().getReasonPhrase();
            throw new JsonRestClientResponseException(code, "Unexpected request HTTP response (" + code + ") " + reason);
        }
    }
}

