/*
 * © 2022-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.integration.cloudsdk.decorator;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.RequestContextRunner;
import com.sap.cds.services.utils.RequestContextSuppressor;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextDecorator;
import java.util.concurrent.Callable;

public class CdsThreadContextDecorator implements ThreadContextDecorator {

  private final CdsRuntime runtime;

  public CdsThreadContextDecorator(CdsRuntime runtime) {
    this.runtime = runtime;
  }

  @Override
  public int getPriority() {
    // call this before any Cloud SDK decorators
    return -10;
  }

  @Override
  public <T> Callable<T> decorateCallable(final Callable<T> callable) {
    if (RequestContextSuppressor.isSuppressNewRequestContext()) {
      return callable::call;
    }

    RequestContextRunner runner = runtime.requestContext();
    return () ->
        runner.run(
            context -> {
              try {
                return callable.call();
              } catch (RuntimeException e) { // NOSONAR
                throw e;
              } catch (Exception e) {
                throw new RuntimeException(e); // NOSONAR
              }
            });
  }
}
