/*
 * © 2022-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.integration.cloudsdk.facade;

import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cloud.sdk.cloudplatform.requestheader.DefaultRequestHeaderContainer;
import com.sap.cloud.sdk.cloudplatform.requestheader.RequestHeaderContainer;
import com.sap.cloud.sdk.cloudplatform.requestheader.RequestHeaderFacade;
import io.vavr.control.Try;
import java.util.Map;

public class CdsRequestHeaderFacade implements RequestHeaderFacade {

  private final CdsRuntime runtime;

  public CdsRequestHeaderFacade(CdsRuntime runtime) {
    this.runtime = runtime;
  }

  @Override
  public Try<RequestHeaderContainer> tryGetRequestHeaders() {
    return Try.of(
        () -> {
          final Map<String, String> headers =
              RequestContext.getCurrent(runtime).getParameterInfo().getHeaders();
          return DefaultRequestHeaderContainer.fromSingleValueMap(headers);
        });
  }
}
