/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.integration.cloudsdk.destination;

import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.TenantAwareCache;
import com.sap.cloud.sdk.cloudplatform.connectivity.ApacheHttpClient5Factory;
import com.sap.cloud.sdk.cloudplatform.connectivity.ApacheHttpClient5FactoryBuilder;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import java.util.function.Supplier;
import org.apache.hc.client5.http.classic.HttpClient;

public class HttpClient5Provider
implements Supplier<HttpClient> {
    private final TenantAwareCache<HttpClient, Boolean> clientCache;

    public HttpClient5Provider(HttpDestination destination, CdsProperties.ConnectionPool config, CdsRuntime runtime) {
        ApacheHttpClient5FactoryBuilder builder = new ApacheHttpClient5FactoryBuilder();
        builder.timeoutInMilliseconds((int)config.getTimeout().toMillis());
        builder.maxConnectionsPerRoute(config.getMaxConnectionsPerRoute().intValue());
        builder.maxConnectionsTotal(config.getMaxConnections().intValue());
        ApacheHttpClient5Factory factory = builder.build();
        Supplier<String> tenantSupplier = config.getCombinePools().isEnabled() != false ? () -> "global-pool" : () -> RequestContext.isActive() ? RequestContext.getCurrent((CdsRuntime)runtime).getUserInfo().getTenant() : runtime.getProvidedUserInfo().getTenant();
        this.clientCache = TenantAwareCache.create(tenantSupplier, () -> factory.createHttpClient((HttpDestinationProperties)destination), () -> true);
    }

    @Override
    public HttpClient get() {
        return (HttpClient)this.clientCache.findOrCreate();
    }
}

