/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.integration.cloudsdk.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.integration.cloudsdk.destination.HttpClient5Provider;
import com.sap.cds.integration.cloudsdk.rest.client.JsonRestClientResponseException;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.ApacheHttpClient5Accessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceRuntimeException;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestDeniedException;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRestClient {
    private static final Logger logger = LoggerFactory.getLogger(JsonRestClient.class);
    private static final String JSON_CONTENT = "application/json";
    private static final String CONTENT_TYPE = "content-type";
    protected final ObjectMapper mapper = new ObjectMapper();
    private final Supplier<HttpClient> clientProvider;

    public JsonRestClient(ServiceBindingDestinationOptions options) {
        this(options, new CdsProperties.ConnectionPool(Duration.ofSeconds(60L), Integer.valueOf(2), Integer.valueOf(20)));
    }

    public JsonRestClient(ServiceBindingDestinationOptions options, CdsProperties.ConnectionPool connectionPool) {
        this.clientProvider = new HttpClient5Provider(ServiceBindingDestinationLoader.defaultLoaderChain().getDestination(options), connectionPool, null);
    }

    public JsonRestClient(String destinationName, String retrievalStrategy) {
        this.clientProvider = () -> {
            HttpDestination destination = ((Destination)DestinationAccessor.getLoader().tryGetDestination(destinationName, DestinationOptions.builder().parameter("scp.cf.destinationRetrievalStrategy", (Object)retrievalStrategy).build()).getOrElseThrow(failure -> {
                if (failure instanceof DestinationAccessException) {
                    DestinationAccessException daex = (DestinationAccessException)failure;
                    throw daex;
                }
                throw new DestinationAccessException("Failed to get destination with name '" + destinationName + "'.", failure);
            })).asHttp();
            return ApacheHttpClient5Accessor.getHttpClient((HttpDestinationProperties)destination);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode getRequest(String path) throws IOException {
        HttpGet get = new HttpGet(path);
        try {
            JsonNode jsonNode = this.handleRequest((ClassicHttpRequest)get, response -> this.handleJsonResponse(response));
            return jsonNode;
        }
        finally {
            get.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequestWithOnlyResponseCode(String path) throws IOException {
        HttpGet get = new HttpGet(path);
        try {
            int n = this.handleRequest((ClassicHttpRequest)get, response -> response.getCode());
            return n;
        }
        finally {
            get.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode deleteRequest(String path) throws IOException {
        HttpDelete del = new HttpDelete(path);
        try {
            JsonNode jsonNode = this.handleRequest((ClassicHttpRequest)del, response -> this.handleJsonResponse(response));
            return jsonNode;
        }
        finally {
            del.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int putRequestWithOnlyResponseCode(String path, JsonNode data) throws IOException {
        HttpPut put = new HttpPut(path);
        if (data != null) {
            put.setEntity((HttpEntity)new StringEntity(this.mapper.writer().writeValueAsString((Object)data), ContentType.APPLICATION_JSON));
        }
        try {
            int n = this.handleRequest((ClassicHttpRequest)put, response -> {
                EntityUtils.consume((HttpEntity)response.getEntity());
                int code = response.getCode();
                if (code < 200 || code > 207) {
                    String reason = response.getReasonPhrase();
                    throw new JsonRestClientResponseException(code, "Unexpected request HTTP response (" + code + ") " + reason);
                }
                return code;
            });
            return n;
        }
        finally {
            put.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode putRequest(String path, JsonNode data) throws IOException {
        HttpPut put = new HttpPut(path);
        if (data != null) {
            put.setEntity((HttpEntity)new StringEntity(this.mapper.writer().writeValueAsString((Object)data), ContentType.APPLICATION_JSON));
        }
        try {
            JsonNode jsonNode = this.handleRequest((ClassicHttpRequest)put, response -> this.handleJsonResponse(response));
            return jsonNode;
        }
        finally {
            put.reset();
        }
    }

    public JsonNode postRequest(String path, JsonNode data) throws IOException {
        String strData = this.mapper.writer().writeValueAsString((Object)data);
        return this.postRequest(path, strData, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode postRequest(String path, String data, Map<String, Object> headers) throws IOException {
        HttpPost post = new HttpPost(path);
        if (headers != null) {
            headers.forEach((k, v) -> post.setHeader(k, (Object)v.toString()));
        }
        if (data != null) {
            post.setEntity((HttpEntity)new StringEntity(data, ContentType.APPLICATION_JSON));
        }
        try {
            JsonNode jsonNode = this.handleRequest((ClassicHttpRequest)post, response -> this.handleJsonResponse(response));
            return jsonNode;
        }
        finally {
            post.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int patchRequestWithOnlyResponseCode(String path, JsonNode data) throws IOException {
        HttpPatch patch = new HttpPatch(path);
        if (data != null) {
            patch.setEntity((HttpEntity)new StringEntity(this.mapper.writer().writeValueAsString((Object)data), ContentType.APPLICATION_JSON));
        }
        try {
            int n = this.handleRequest((ClassicHttpRequest)patch, response -> {
                EntityUtils.consume((HttpEntity)response.getEntity());
                int code = response.getCode();
                if (code < 200 || code > 207) {
                    String reason = response.getReasonPhrase();
                    throw new JsonRestClientResponseException(code, "Unexpected request HTTP response (" + code + ") " + reason);
                }
                return code;
            });
            return n;
        }
        finally {
            patch.reset();
        }
    }

    private <T> T handleRequest(ClassicHttpRequest request, ResponseHandler<T> responseHandler) throws IOException {
        this.setHeaders(request);
        try {
            return (T)((CloseableHttpClient)this.clientProvider.get()).execute(request, responseHandler::handle);
        }
        catch (DestinationAccessException | ResilienceRuntimeException | TokenRequestDeniedException | TokenRequestFailedException e) {
            if (ExceptionUtils.indexOfThrowable((Throwable)e, TokenRequestDeniedException.class) >= 0) {
                throw new JsonRestClientResponseException(401, "Authentication invalid: " + e.getMessage());
            }
            if (ExceptionUtils.indexOfThrowable((Throwable)e, TokenRequestFailedException.class) >= 0) {
                throw new JsonRestClientResponseException(401, "Authentication failed: " + e.getMessage());
            }
            throw e;
        }
    }

    private void setHeaders(ClassicHttpRequest request) {
        logger.debug("Creating {} request to {}", (Object)request.getMethod(), (Object)request.getRequestUri());
        request.removeHeaders(CONTENT_TYPE);
        request.addHeader(CONTENT_TYPE, (Object)JSON_CONTENT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonNode handleJsonResponse(ClassicHttpResponse response) throws IOException {
        try (ClassicHttpResponse resp = response;){
            int code = resp.getCode();
            logger.debug("Responded with status code '{}'", (Object)code);
            if (code >= 200 && code <= 207) {
                String contentType = JSON_CONTENT;
                if (resp.getEntity() == null) {
                    JsonNode jsonNode = (JsonNode)this.mapper.readValue("{}", JsonNode.class);
                    return jsonNode;
                }
                if (resp.getEntity().getContentType() != null) {
                    contentType = resp.getEntity().getContentType();
                }
                if (!contentType.contains(JSON_CONTENT)) throw new IOException("Unexpected response format: Expected JSON but found '" + contentType + "'");
                String jsonData = EntityUtils.toString((HttpEntity)resp.getEntity());
                JsonNode jsonNode = (JsonNode)this.mapper.readValue(jsonData, JsonNode.class);
                return jsonNode;
            }
            String reason = resp.getReasonPhrase();
            throw new JsonRestClientResponseException(code, "Unexpected request HTTP response (" + code + ") " + reason);
        }
        catch (ParseException e) {
            throw new IOException("Failed to parse response entity", e);
        }
    }

    @FunctionalInterface
    private static interface ResponseHandler<T> {
        public T handle(ClassicHttpResponse var1) throws IOException, JsonRestClientResponseException;
    }
}

