package ${package};

import static org.hamcrest.CoreMatchers.containsString;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import ${applicationPackage}.Application;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = Application.class)
@AutoConfigureMockMvc
public class ${name} {

	@Autowired
	private MockMvc mockMvc;

	@Test
	public void testReadBooks() throws Exception {
		mockMvc.perform(MockMvcRequestBuilders.get("/odata/v2/CatalogService/Books").accept("application/json"))
				.andExpect(status().isOk())
				.andExpect(jsonPath("d.results[0].title").value(containsString("Wuthering Heights")))
				.andExpect(jsonPath("d.results[0].stock").value(100))
				.andExpect(jsonPath("d.results[1].title").value(containsString("Jane Eyre (discounted)")))
				.andExpect(jsonPath("d.results[1].stock").value(500));
	}
}
