package com.sap.cds.maven.plugin.build;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

/**
 * Performs an initial CDS build (same as <code>mvn cds:build</code>) and then watches for changes in the CDS model. If changes are detected, 
 * the CDS model is re-built automatically.
 * 
 * In contrast to <code>mvn cds:watch</code> this goal does not start a CAP Java NG application.
 * <br>
 * <strong>Note:</strong> This goal can only be executed from the command line.<br>
 * <br>
 *
 * @since 1.25.0
 */
@Mojo(name = "auto-build", defaultPhase = LifecyclePhase.NONE, aggregator = true)
public class AutoBuildMojo extends WatchMojo {

	@Override
	public void execute() throws MojoExecutionException {
		super.noStart = true;
		super.execute();
	}
}
