package com.sap.cds.maven.plugin.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;

import org.yaml.snakeyaml.Yaml;

public class TriggerFileUtil {

	static final String SPRING_DEVTOOLS_RESTART_TRIGGER_FILE = "spring.devtools.restart.trigger-file";

	private TriggerFileUtil() {
		// no instances
	}

	public static Optional<String> getTriggerFilePath(String basePath) {
		try {
			return TriggerFileUtil.getTriggerFileName(basePath);
		} catch (IOException e) {
			throw new IllegalStateException("failed to load trigger file path from application.yaml", e);
		}
	}

	@SuppressWarnings("unchecked")
	public static Optional<String> getTriggerFileName(String basePath) throws IOException {
		// TODO also try to read application.properties
		File applicationYamlFile = new File(basePath + "application.yaml");
		File applicationYmlFile = new File(basePath + "application.yml");
		if (applicationYamlFile.exists() || applicationYmlFile.exists()) {
			Yaml applicationYaml = new Yaml();
			try (Reader applicationYamlReader = applicationYamlFile.exists() ? new FileReader(applicationYamlFile)
					: new FileReader(applicationYmlFile)) {
				for (Object map : applicationYaml.loadAll(applicationYamlReader)) {
					Optional<String> configValue = Utils
							.readDeepFromMap((Map<String, Object>) map, SPRING_DEVTOOLS_RESTART_TRIGGER_FILE)
							.map(fileName -> basePath + fileName);
					if (configValue.isPresent()) {
						return configValue;
					}
				}

			}
		}
		return Optional.empty();
	}

}
