/**************************************************************************
 * (C) 2019-2022 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.maven.plugin;

/**
 * This interface provides access to the logger used by all CDS Mojos.
 *
 * @see "https://docs.oracle.com/javase/tutorial/java/data/numberformat.html"
 */
public interface CdsMojoLogger {
	/**
	 * Writes a debug message to log.
	 *
	 * @param message the message
	 * @param args    the arguments
	 */
	void logDebug(String message, Object... args);

	/**
	 * Writes a debug message to log.
	 *
	 * @param error the exception causing this debug entry
	 */
	void logDebug(Throwable error);

	/**
	 * Writes an error message to log.
	 *
	 * @param message the message
	 * @param args    the arguments
	 */
	void logError(String message, Object... args);

	/**
	 * Writes an error message to log.
	 *
	 * @param message the message
	 * @param error   the exception causing the error
	 * @param args    the arguments
	 */
	void logError(String message, Throwable error, Object... args);

	/**
	 * Writes an error message to log.
	 *
	 * @param error the exception causing the error entry
	 */
	void logError(Throwable error);

	/**
	 * Writes a debug message to log.
	 *
	 * @param message the message
	 * @param args    the arguments
	 */
	void logInfo(String message, Object... args);

	/**
	 * Writes a warning message to log.
	 *
	 * @param message the message
	 * @param args    the arguments
	 */
	void logWarn(String message, Object... args);

	/**
	 * Writes a warning message to log.
	 *
	 * @param message the message
	 * @param error   the exception causing the warning
	 * @param args    the arguments
	 */
	void logWarn(String message, Throwable error, Object... args);

	/**
	 * Writes a warning message to log.
	 *
	 * @param error   the exception causing the warning
	 */
	void logWarn(Throwable error);
}
