/**************************************************************************
 * (C) 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.maven.plugin.add;

import org.apache.maven.plugin.MojoExecutionException;

/**
 * An {@link Addable} is a feature or some kind of fragment, that can be added to a CAP Java project.
 */
interface Addable {

	/**
	 * Adds the feature or fragment to the CAP Java project.
	 * 
	 * @param profile the name of the spring profile that is added to application.yaml
	 * @throws MojoExecutionException if adding the feature or fragment failed
	 */
	void add(String profile) throws MojoExecutionException;
}
