package com.sap.cds.maven.plugin.util;

import java.io.File;
import java.io.IOException;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class CdsrcUtils {

	private final ObjectNode rootNode;
	private final File cdsrcJson;
	private final ObjectMapper mapper = new ObjectMapper();

	public CdsrcUtils(File cdsrcJson) throws IOException {
		this.cdsrcJson = cdsrcJson;
		this.rootNode = (ObjectNode) this.mapper.readTree(this.cdsrcJson);
	}

	public CdsrcUtils enableBetterSqlite() {
		getCdscNode().set("betterSqliteSessionVariables", BooleanNode.TRUE);
		return this;
	}

	public void save() throws IOException {
		this.mapper.writerWithDefaultPrettyPrinter().writeValue(this.cdsrcJson, this.rootNode);
	}

	private ObjectNode getCdscNode() {
		ObjectNode cdscNode = (ObjectNode) this.rootNode.get("cdsc");
		if (cdscNode == null) {
			cdscNode = new ObjectNode(JsonNodeFactory.instance);
			this.rootNode.set("cdsc", cdscNode);
		}
		return cdscNode;
	}
}
