/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services;

import com.sap.cds.Cds4jServiceLoader;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceExceptionUtils;
import com.sap.cds.services.messages.MessageTarget;
import java.util.Locale;
import java.util.function.Function;
import org.slf4j.helpers.MessageFormatter;

public class ServiceException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected final ErrorStatus errorStatus;
    protected MessageTarget messageTarget;
    protected final Object[] args;
    protected static ServiceExceptionUtils Utils = (ServiceExceptionUtils)Cds4jServiceLoader.load(ServiceExceptionUtils.class);

    public ServiceException(Throwable e) {
        this(null, e.getMessage(), e);
    }

    public ServiceException(String message, Object ... args) {
        this(null, message, args);
    }

    public ServiceException(ErrorStatus errorStatus, String message, Object ... args) {
        super(message);
        Throwable throwableCandidate = MessageFormatter.getThrowableCandidate((Object[])args);
        if (throwableCandidate != null) {
            super.initCause(throwableCandidate);
            this.args = MessageFormatter.trimmedCopy((Object[])args);
        } else {
            this.args = args;
        }
        this.errorStatus = errorStatus;
    }

    public ErrorStatus getErrorStatus() {
        ErrorStatus theErrorStatus = this.getNearest(e -> e.errorStatus);
        return theErrorStatus == null ? ErrorStatuses.SERVER_ERROR : theErrorStatus;
    }

    public MessageTarget getMessageTarget() {
        return this.getNearest(e -> e.messageTarget);
    }

    @Override
    public String getMessage() {
        return Utils.getMessage(this.getPlainMessage(), this.args);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMessage(null);
    }

    public String getLocalizedMessage(Locale locale) {
        return Utils.getLocalizedMessage(this.getPlainMessage(), this.args, locale);
    }

    public String getPlainMessage() {
        return super.getMessage();
    }

    private <T> T getNearest(Function<ServiceException, T> provider) {
        T value = provider.apply(this);
        for (Throwable cause = this.getCause(); value == null && cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ServiceException)) continue;
            value = provider.apply((ServiceException)cause);
        }
        return value;
    }

    public ServiceException messageTarget(String target) {
        return this.messageTarget(Utils.getMessageTarget(target));
    }

    public ServiceException messageTarget(MessageTarget target) {
        this.messageTarget = target;
        return this;
    }

    public ServiceException messageTarget(String entity, Function<StructuredType<?>, Object> path) {
        this.messageTarget = Utils.getMessageTarget(null, entity, path);
        return this;
    }

    public ServiceException messageTarget(String prefix, String entity, Function<StructuredType<?>, Object> path) {
        this.messageTarget = Utils.getMessageTarget(prefix, entity, path);
        return this;
    }

    public <E extends StructuredType<E>> ServiceException messageTarget(Class<E> entity, Function<E, Object> path) {
        this.messageTarget = Utils.getMessageTarget(null, entity, path);
        return this;
    }

    public <E extends StructuredType<E>> ServiceException messageTarget(String prefix, Class<E> entity, Function<E, Object> path) {
        this.messageTarget = Utils.getMessageTarget(prefix, entity, path);
        return this;
    }
}

