/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.environment;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CdsProperties {
    private Environment environment = new Environment();
    private DataSource dataSource = new DataSource();
    private Model model = new Model();
    private Security security = new Security();
    private Servlet indexPage = new Servlet("/");
    private ODataV4 odataV4 = new ODataV4();
    private ODataV2 odataV2 = new ODataV2();
    private Messaging messaging = new Messaging();
    private MultiTenancy multiTenancy = new MultiTenancy();
    private Application application = new Application();
    private Remote remote = new Remote();
    private Locales locales = new Locales();
    private Errors errors = new Errors();
    private Drafts drafts = new Drafts();
    private Query query = new Query();
    private Sql sql = new Sql();
    private AuditLog auditLog = new AuditLog();
    private Outbox outbox = new Outbox();

    @Deprecated
    public Map<String, Application.ApplicationServiceConfig> getServices() {
        return this.getApplication().getServices();
    }

    @Deprecated
    public void setServices(Map<String, Application.ApplicationServiceConfig> services) {
        this.getApplication().setServices(services);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Model getModel() {
        return this.model;
    }

    public Security getSecurity() {
        return this.security;
    }

    public Servlet getIndexPage() {
        return this.indexPage;
    }

    public ODataV4 getOdataV4() {
        return this.odataV4;
    }

    public ODataV2 getOdataV2() {
        return this.odataV2;
    }

    public Messaging getMessaging() {
        return this.messaging;
    }

    public MultiTenancy getMultiTenancy() {
        return this.multiTenancy;
    }

    public Application getApplication() {
        return this.application;
    }

    public Remote getRemote() {
        return this.remote;
    }

    public Locales getLocales() {
        return this.locales;
    }

    public Errors getErrors() {
        return this.errors;
    }

    public Drafts getDrafts() {
        return this.drafts;
    }

    public Query getQuery() {
        return this.query;
    }

    public Sql getSql() {
        return this.sql;
    }

    public AuditLog getAuditLog() {
        return this.auditLog;
    }

    public Outbox getOutbox() {
        return this.outbox;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public void setIndexPage(Servlet indexPage) {
        this.indexPage = indexPage;
    }

    public void setOdataV4(ODataV4 odataV4) {
        this.odataV4 = odataV4;
    }

    public void setOdataV2(ODataV2 odataV2) {
        this.odataV2 = odataV2;
    }

    public void setMessaging(Messaging messaging) {
        this.messaging = messaging;
    }

    public void setMultiTenancy(MultiTenancy multiTenancy) {
        this.multiTenancy = multiTenancy;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public void setRemote(Remote remote) {
        this.remote = remote;
    }

    public void setLocales(Locales locales) {
        this.locales = locales;
    }

    public void setErrors(Errors errors) {
        this.errors = errors;
    }

    public void setDrafts(Drafts drafts) {
        this.drafts = drafts;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void setSql(Sql sql) {
        this.sql = sql;
    }

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public void setOutbox(Outbox outbox) {
        this.outbox = outbox;
    }

    public static class Outbox {
        private InMemory inMemory = new InMemory();
        private Persistent persistent = new Persistent();

        public InMemory getInMemory() {
            return this.inMemory;
        }

        public Persistent getPersistent() {
            return this.persistent;
        }

        public void setInMemory(InMemory inMemory) {
            this.inMemory = inMemory;
        }

        public void setPersistent(Persistent persistent) {
            this.persistent = persistent;
        }

        public static class Persistent
        extends Enabled {
            private int maxAttempts = 10;
            private Duration emitTimeout = Duration.ofMinutes(1L);
            private int chunkSize = 10;
            private Duration maxPause = Duration.ofMinutes(10L);
            private Duration tenantsInfoRefreshInterval = Duration.ofMinutes(5L);
            private Enabled triggerSchedule = new Enabled(true);
            private Enabled storeLastError = new Enabled(true);

            public Persistent() {
                super(true);
            }

            public int getMaxAttempts() {
                return this.maxAttempts;
            }

            public Duration getEmitTimeout() {
                return this.emitTimeout;
            }

            public int getChunkSize() {
                return this.chunkSize;
            }

            public Duration getMaxPause() {
                return this.maxPause;
            }

            public Duration getTenantsInfoRefreshInterval() {
                return this.tenantsInfoRefreshInterval;
            }

            public Enabled getTriggerSchedule() {
                return this.triggerSchedule;
            }

            public Enabled getStoreLastError() {
                return this.storeLastError;
            }

            public void setMaxAttempts(int maxAttempts) {
                this.maxAttempts = maxAttempts;
            }

            public void setEmitTimeout(Duration emitTimeout) {
                this.emitTimeout = emitTimeout;
            }

            public void setChunkSize(int chunkSize) {
                this.chunkSize = chunkSize;
            }

            public void setMaxPause(Duration maxPause) {
                this.maxPause = maxPause;
            }

            public void setTenantsInfoRefreshInterval(Duration tenantsInfoRefreshInterval) {
                this.tenantsInfoRefreshInterval = tenantsInfoRefreshInterval;
            }

            public void setTriggerSchedule(Enabled triggerSchedule) {
                this.triggerSchedule = triggerSchedule;
            }

            public void setStoreLastError(Enabled storeLastError) {
                this.storeLastError = storeLastError;
            }
        }

        public static class InMemory
        extends Enabled {
            private boolean emitDuringChangeSetContext = false;

            public InMemory() {
                super(true);
            }

            public boolean isEmitDuringChangeSetContext() {
                return this.emitDuringChangeSetContext;
            }

            public void setEmitDuringChangeSetContext(boolean emitDuringChangeSetContext) {
                this.emitDuringChangeSetContext = emitDuringChangeSetContext;
            }
        }
    }

    public static class AuditLog {
        private Enabled v2 = new Enabled(true);
        private PersonalData personalData = new PersonalData(true);
        private Outbox outbox = new Outbox(true);

        public Enabled getV2() {
            return this.v2;
        }

        public PersonalData getPersonalData() {
            return this.personalData;
        }

        public Outbox getOutbox() {
            return this.outbox;
        }

        public void setV2(Enabled v2) {
            this.v2 = v2;
        }

        public void setPersonalData(PersonalData personalData) {
            this.personalData = personalData;
        }

        public void setOutbox(Outbox outbox) {
            this.outbox = outbox;
        }

        public static class Outbox
        extends Enabled {
            private Enabled persistent = new Enabled(true);

            public Outbox(Boolean byDefault) {
                super(byDefault);
            }

            public Enabled getPersistent() {
                return this.persistent;
            }

            public void setPersistent(Enabled persistent) {
                this.persistent = persistent;
            }
        }

        public static class PersonalData
        extends Enabled {
            private boolean throwOnMissingDataSubject = false;

            public PersonalData(Boolean byDefault) {
                super(byDefault);
            }

            public boolean isThrowOnMissingDataSubject() {
                return this.throwOnMissingDataSubject;
            }

            public void setThrowOnMissingDataSubject(boolean throwOnMissingDataSubject) {
                this.throwOnMissingDataSubject = throwOnMissingDataSubject;
            }
        }
    }

    public static class Servlet
    extends Enabled {
        private String path;

        public Servlet(String defaultPath) {
            super(true);
            this.path = defaultPath;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    public static class Enabled {
        private Boolean enabled;

        public Enabled(Boolean byDefault) {
            this.enabled = byDefault;
        }

        public Boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Sql {
        private String supportedLocales = "de,fr";
        private int maxBatchSize = 1000;
        private boolean ignoreVirtualElements = true;
        private Hana hana = new Hana();
        private Search search = new Search();

        public String getSupportedLocales() {
            return this.supportedLocales;
        }

        public int getMaxBatchSize() {
            return this.maxBatchSize;
        }

        public boolean isIgnoreVirtualElements() {
            return this.ignoreVirtualElements;
        }

        public Hana getHana() {
            return this.hana;
        }

        public Search getSearch() {
            return this.search;
        }

        public void setSupportedLocales(String supportedLocales) {
            this.supportedLocales = supportedLocales;
        }

        public void setMaxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        public void setIgnoreVirtualElements(boolean ignoreVirtualElements) {
            this.ignoreVirtualElements = ignoreVirtualElements;
        }

        public void setHana(Hana hana) {
            this.hana = hana;
        }

        public void setSearch(Search search) {
            this.search = search;
        }

        public static class Hana {
            private boolean ignoreLocale = false;
            private Docstore docstore = new Docstore();

            public boolean isIgnoreLocale() {
                return this.ignoreLocale;
            }

            public Docstore getDocstore() {
                return this.docstore;
            }

            public void setIgnoreLocale(boolean ignoreLocale) {
                this.ignoreLocale = ignoreLocale;
            }

            public void setDocstore(Docstore docstore) {
                this.docstore = docstore;
            }

            public static class Docstore
            extends Enabled {
                public Docstore() {
                    super(false);
                }
            }
        }

        public static class Search {
            private boolean useLocalizedView;

            public boolean isUseLocalizedView() {
                return this.useLocalizedView;
            }

            public void setUseLocalizedView(boolean useLocalizedView) {
                this.useLocalizedView = useLocalizedView;
            }
        }
    }

    public static class Query {
        private Limit limit = new Limit();
        private Enabled implicitSorting = new Enabled(true);

        public Limit getLimit() {
            return this.limit;
        }

        public Enabled getImplicitSorting() {
            return this.implicitSorting;
        }

        public void setLimit(Limit limit) {
            this.limit = limit;
        }

        public void setImplicitSorting(Enabled implicitSorting) {
            this.implicitSorting = implicitSorting;
        }

        public static class Limit {
            private int _default = 0;
            private int max = 1000;

            public int getDefault() {
                return this._default;
            }

            public void setDefault(int _default) {
                this._default = _default;
            }

            public int getMax() {
                return this.max;
            }

            public void setMax(int max) {
                this.max = max;
            }
        }
    }

    public static class Drafts {
        private Duration cancellationTimeout = Duration.ofMinutes(15L);
        private Enabled associationsToInactiveEntities = new Enabled(true);
        private Duration deletionTimeout = Duration.ofDays(30L);
        private GC gc = new GC();

        public Duration getCancellationTimeout() {
            return this.cancellationTimeout;
        }

        public Enabled getAssociationsToInactiveEntities() {
            return this.associationsToInactiveEntities;
        }

        public Duration getDeletionTimeout() {
            return this.deletionTimeout;
        }

        public GC getGc() {
            return this.gc;
        }

        public void setCancellationTimeout(Duration cancellationTimeout) {
            this.cancellationTimeout = cancellationTimeout;
        }

        public void setAssociationsToInactiveEntities(Enabled associationsToInactiveEntities) {
            this.associationsToInactiveEntities = associationsToInactiveEntities;
        }

        public void setDeletionTimeout(Duration deletionTimeout) {
            this.deletionTimeout = deletionTimeout;
        }

        public void setGc(GC gc) {
            this.gc = gc;
        }

        public static class GC
        extends Enabled {
            private Duration interval = Duration.ofHours(6L);

            public GC() {
                super(true);
            }

            public Duration getInterval() {
                return this.interval;
            }

            public void setInterval(Duration interval) {
                this.interval = interval;
            }
        }
    }

    public static class Errors {
        private Enabled stackMessages = new Enabled(true);
        private boolean extended = false;
        private boolean combined = true;

        public Enabled getStackMessages() {
            return this.stackMessages;
        }

        public boolean isExtended() {
            return this.extended;
        }

        public boolean isCombined() {
            return this.combined;
        }

        public void setStackMessages(Enabled stackMessages) {
            this.stackMessages = stackMessages;
        }

        public void setExtended(boolean extended) {
            this.extended = extended;
        }

        public void setCombined(boolean combined) {
            this.combined = combined;
        }
    }

    public static class Locales {
        private Normalization normalization = new Normalization();

        public Normalization getNormalization() {
            return this.normalization;
        }

        public void setNormalization(Normalization normalization) {
            this.normalization = normalization;
        }

        public static class Normalization {
            private boolean defaults = true;
            private List<String> includeList = new ArrayList<String>();

            @Deprecated
            public List<String> getWhiteList() {
                return this.getIncludeList();
            }

            @Deprecated
            public void setWhiteList(List<String> whiteList) {
                this.setIncludeList(whiteList);
            }

            public boolean isDefaults() {
                return this.defaults;
            }

            public List<String> getIncludeList() {
                return this.includeList;
            }

            public void setDefaults(boolean defaults) {
                this.defaults = defaults;
            }

            public void setIncludeList(List<String> includeList) {
                this.includeList = includeList;
            }
        }
    }

    public static class Remote {
        private Map<String, RemoteServiceConfig> services = new HashMap<String, RemoteServiceConfig>();

        public Map<String, RemoteServiceConfig> getServices() {
            this.services.forEach((k, v) -> {
                if (v.getName() == null || v.getName().trim().isEmpty()) {
                    v.setName((String)k);
                }
            });
            return this.services;
        }

        public RemoteServiceConfig getService(String name) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getName(), name)).findFirst().orElse(new RemoteServiceConfig(name));
        }

        public List<RemoteServiceConfig> getServicesByModel(String model) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getModel(), model) || s.getModel() == null && Objects.equals(s.getName(), model)).collect(Collectors.toList());
        }

        public void setServices(Map<String, RemoteServiceConfig> services) {
            this.services = services;
        }

        public static class RemoteServiceConfig {
            private String name;
            private String model;
            private Destination destination = new Destination();

            public RemoteServiceConfig() {
            }

            public RemoteServiceConfig(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public String getModel() {
                return this.model;
            }

            public Destination getDestination() {
                return this.destination;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setModel(String model) {
                this.model = model;
            }

            public void setDestination(Destination destination) {
                this.destination = destination;
            }

            public static class Destination {
                public static final String ODATA_V2_TYPE = "odata-v2";
                public static final String ODATA_V4_TYPE = "odata-v4";
                private String type = "odata-v4";
                private String name;
                private String suffix;
                private String service;
                private Map<String, Object> properties = new HashMap<String, Object>();
                private Map<String, String> headers = new HashMap<String, String>();
                private Map<String, String> queries = new HashMap<String, String>();
                private String retrievalStrategy;
                private String tokenExchangeStrategy;

                public String getType() {
                    return this.type;
                }

                public String getName() {
                    return this.name;
                }

                public String getSuffix() {
                    return this.suffix;
                }

                public String getService() {
                    return this.service;
                }

                public Map<String, Object> getProperties() {
                    return this.properties;
                }

                public Map<String, String> getHeaders() {
                    return this.headers;
                }

                public Map<String, String> getQueries() {
                    return this.queries;
                }

                public String getRetrievalStrategy() {
                    return this.retrievalStrategy;
                }

                public String getTokenExchangeStrategy() {
                    return this.tokenExchangeStrategy;
                }

                public void setType(String type) {
                    this.type = type;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setSuffix(String suffix) {
                    this.suffix = suffix;
                }

                public void setService(String service) {
                    this.service = service;
                }

                public void setProperties(Map<String, Object> properties) {
                    this.properties = properties;
                }

                public void setHeaders(Map<String, String> headers) {
                    this.headers = headers;
                }

                public void setQueries(Map<String, String> queries) {
                    this.queries = queries;
                }

                public void setRetrievalStrategy(String retrievalStrategy) {
                    this.retrievalStrategy = retrievalStrategy;
                }

                public void setTokenExchangeStrategy(String tokenExchangeStrategy) {
                    this.tokenExchangeStrategy = tokenExchangeStrategy;
                }
            }
        }
    }

    public static class Application {
        private Map<String, ApplicationServiceConfig> services = new HashMap<String, ApplicationServiceConfig>();

        public Map<String, ApplicationServiceConfig> getServices() {
            this.services.forEach((k, v) -> {
                if (v.getName() == null || v.getName().trim().isEmpty()) {
                    v.setName((String)k);
                }
            });
            return this.services;
        }

        public ApplicationServiceConfig getService(String name) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getName(), name)).findFirst().orElse(new ApplicationServiceConfig(name));
        }

        public List<ApplicationServiceConfig> getServicesByModel(String model) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getModel(), model) || s.getModel() == null && Objects.equals(s.getName(), model)).collect(Collectors.toList());
        }

        public void setServices(Map<String, ApplicationServiceConfig> services) {
            this.services = services;
        }

        public static class ApplicationServiceConfig {
            private String name;
            private String model;
            private Serve serve = new Serve();

            public ApplicationServiceConfig() {
            }

            public ApplicationServiceConfig(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public String getModel() {
                return this.model;
            }

            public Serve getServe() {
                return this.serve;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setModel(String model) {
                this.model = model;
            }

            public void setServe(Serve serve) {
                this.serve = serve;
            }

            public static class Serve {
                private boolean ignore;
                private String path;
                private List<String> protocols = new ArrayList<String>();
                private List<Endpoint> endpoints = new ArrayList<Endpoint>();

                public boolean isIgnore() {
                    return this.ignore;
                }

                public String getPath() {
                    return this.path;
                }

                public List<String> getProtocols() {
                    return this.protocols;
                }

                public List<Endpoint> getEndpoints() {
                    return this.endpoints;
                }

                public void setIgnore(boolean ignore) {
                    this.ignore = ignore;
                }

                public void setPath(String path) {
                    this.path = path;
                }

                public void setProtocols(List<String> protocols) {
                    this.protocols = protocols;
                }

                public void setEndpoints(List<Endpoint> endpoints) {
                    this.endpoints = endpoints;
                }

                public static class Endpoint {
                    private String path;
                    private String protocol;

                    public String getPath() {
                        return this.path;
                    }

                    public String getProtocol() {
                        return this.protocol;
                    }

                    public void setPath(String path) {
                        this.path = path;
                    }

                    public void setProtocol(String protocol) {
                        this.protocol = protocol;
                    }
                }
            }
        }
    }

    public static class MultiTenancy {
        private String callbackUrl;
        private Servlet endpoint = new Servlet("/mt/v1.0/subscriptions");
        private DataSource dataSource = new DataSource();
        private ServiceManager serviceManager = new ServiceManager();
        private Security security = new Security();
        private Deployer deployer = new Deployer();
        private Sidecar sidecar = new Sidecar();
        private AppUi appUi = new AppUi();
        private HealthCheck healthCheck = new HealthCheck();
        private Liquibase liquibase = new Liquibase();
        private InstanceManagerMigration instanceManagerMigration = new InstanceManagerMigration();
        private ProvisioningService provisioning = new ProvisioningService();
        private Enabled mtxs = new Enabled(false);

        @Deprecated
        public ServiceManager getInstanceManager() {
            return this.serviceManager;
        }

        @Deprecated
        public void setInstanceManager(ServiceManager serviceManager) {
            this.serviceManager = serviceManager;
        }

        public String getCallbackUrl() {
            return this.callbackUrl;
        }

        public Servlet getEndpoint() {
            return this.endpoint;
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public ServiceManager getServiceManager() {
            return this.serviceManager;
        }

        public Security getSecurity() {
            return this.security;
        }

        public Deployer getDeployer() {
            return this.deployer;
        }

        public Sidecar getSidecar() {
            return this.sidecar;
        }

        public AppUi getAppUi() {
            return this.appUi;
        }

        public HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        public Liquibase getLiquibase() {
            return this.liquibase;
        }

        public InstanceManagerMigration getInstanceManagerMigration() {
            return this.instanceManagerMigration;
        }

        public ProvisioningService getProvisioning() {
            return this.provisioning;
        }

        public Enabled getMtxs() {
            return this.mtxs;
        }

        public void setCallbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
        }

        public void setEndpoint(Servlet endpoint) {
            this.endpoint = endpoint;
        }

        public void setDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public void setServiceManager(ServiceManager serviceManager) {
            this.serviceManager = serviceManager;
        }

        public void setSecurity(Security security) {
            this.security = security;
        }

        public void setDeployer(Deployer deployer) {
            this.deployer = deployer;
        }

        public void setSidecar(Sidecar sidecar) {
            this.sidecar = sidecar;
        }

        public void setAppUi(AppUi appUi) {
            this.appUi = appUi;
        }

        public void setHealthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
        }

        public void setLiquibase(Liquibase liquibase) {
            this.liquibase = liquibase;
        }

        public void setInstanceManagerMigration(InstanceManagerMigration instanceManagerMigration) {
            this.instanceManagerMigration = instanceManagerMigration;
        }

        public void setProvisioning(ProvisioningService provisioning) {
            this.provisioning = provisioning;
        }

        public void setMtxs(Enabled mtxs) {
            this.mtxs = mtxs;
        }

        public static class ProvisioningService {
            private String url;
            private Duration pollingInterval = Duration.ofSeconds(5L);
            private Duration pollingTimeout = Duration.ofMinutes(10L);

            public String getUrl() {
                return this.url;
            }

            public Duration getPollingInterval() {
                return this.pollingInterval;
            }

            public Duration getPollingTimeout() {
                return this.pollingTimeout;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public void setPollingInterval(Duration pollingInterval) {
                this.pollingInterval = pollingInterval;
            }

            public void setPollingTimeout(Duration pollingTimeout) {
                this.pollingTimeout = pollingTimeout;
            }
        }

        public static class InstanceManagerMigration {
            private String instanceManagerBindingName;

            public String getInstanceManagerBindingName() {
                return this.instanceManagerBindingName;
            }

            public void setInstanceManagerBindingName(String instanceManagerBindingName) {
                this.instanceManagerBindingName = instanceManagerBindingName;
            }
        }

        public static class Liquibase {
            private String changeLog = "/db/changelog/db.changelog-master.yaml";
            private String contexts;

            public String getChangeLog() {
                return this.changeLog;
            }

            public String getContexts() {
                return this.contexts;
            }

            public void setChangeLog(String changeLog) {
                this.changeLog = changeLog;
            }

            public void setContexts(String contexts) {
                this.contexts = contexts;
            }
        }

        public static class HealthCheck
        extends Enabled {
            private String healthCheckStatement = "";
            private long intervalMillis = 10000L;

            public HealthCheck() {
                super(true);
            }

            public String getHealthCheckStatement() {
                return this.healthCheckStatement;
            }

            public long getIntervalMillis() {
                return this.intervalMillis;
            }

            public void setHealthCheckStatement(String healthCheckStatement) {
                this.healthCheckStatement = healthCheckStatement;
            }

            public void setIntervalMillis(long intervalMillis) {
                this.intervalMillis = intervalMillis;
            }
        }

        public static class AppUi {
            private String url;
            private String tenantSeparator;

            public String getUrl() {
                return this.url;
            }

            public String getTenantSeparator() {
                return this.tenantSeparator;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public void setTenantSeparator(String tenantSeparator) {
                this.tenantSeparator = tenantSeparator;
            }
        }

        public static class Sidecar {
            @Deprecated
            private Cache cache = new Cache();
            private String url;
            private int version = 1;

            @Deprecated
            public Cache getCache() {
                return this.cache;
            }

            public String getUrl() {
                return this.url;
            }

            public int getVersion() {
                return this.version;
            }

            @Deprecated
            public void setCache(Cache cache) {
                this.cache = cache;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public void setVersion(int version) {
                this.version = version;
            }

            public static class Cache {
                private int maxSize = 20;
                private int expirationTime = 600;
                private int refreshTime = 60;

                public int getMaxSize() {
                    return this.maxSize;
                }

                public int getExpirationTime() {
                    return this.expirationTime;
                }

                public int getRefreshTime() {
                    return this.refreshTime;
                }

                public void setMaxSize(int maxSize) {
                    this.maxSize = maxSize;
                }

                public void setExpirationTime(int expirationTime) {
                    this.expirationTime = expirationTime;
                }

                public void setRefreshTime(int refreshTime) {
                    this.refreshTime = refreshTime;
                }
            }
        }

        public static class Deployer {
            private String url;
            private String user;
            private String password;
            private Duration asyncTimeout = Duration.ofMinutes(10L);

            public String getUrl() {
                return this.url;
            }

            public String getUser() {
                return this.user;
            }

            public String getPassword() {
                return this.password;
            }

            public Duration getAsyncTimeout() {
                return this.asyncTimeout;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public void setUser(String user) {
                this.user = user;
            }

            public void setPassword(String password) {
                this.password = password;
            }

            public void setAsyncTimeout(Duration asyncTimeout) {
                this.asyncTimeout = asyncTimeout;
            }
        }

        public static class Security {
            private String subscriptionScope = "mtcallback";
            private String deploymentScope = "mtdeployment";

            public String getSubscriptionScope() {
                return this.subscriptionScope;
            }

            public String getDeploymentScope() {
                return this.deploymentScope;
            }

            public void setSubscriptionScope(String subscriptionScope) {
                this.subscriptionScope = subscriptionScope;
            }

            public void setDeploymentScope(String deploymentScope) {
                this.deploymentScope = deploymentScope;
            }
        }

        public static class ServiceManager {
            private int timeout = 3600;

            public int getTimeout() {
                return this.timeout;
            }

            public void setTimeout(int timeout) {
                this.timeout = timeout;
            }
        }

        public static class DataSource {
            private String pool = "hikari";
            private Enabled combinePools = new Enabled(false);
            private List<String> hanaDatabaseIds = new ArrayList<String>();

            public String getPool() {
                return this.pool;
            }

            public Enabled getCombinePools() {
                return this.combinePools;
            }

            public List<String> getHanaDatabaseIds() {
                return this.hanaDatabaseIds;
            }

            public void setPool(String pool) {
                this.pool = pool;
            }

            public void setCombinePools(Enabled combinePools) {
                this.combinePools = combinePools;
            }

            public void setHanaDatabaseIds(List<String> hanaDatabaseIds) {
                this.hanaDatabaseIds = hanaDatabaseIds;
            }
        }
    }

    public static class Messaging {
        private MessagingWebhooks webhooks = new MessagingWebhooks();
        private boolean resetQueues = false;
        private List<Composite.CompositeServiceConfig.Route> routes = new ArrayList<Composite.CompositeServiceConfig.Route>();
        private Map<String, MessagingServiceConfig> services = new HashMap<String, MessagingServiceConfig>();

        public Map<String, MessagingServiceConfig> getServices() {
            this.services.forEach((k, v) -> {
                if (v.getName() == null || v.getName().trim().isEmpty()) {
                    v.setName((String)k);
                }
            });
            return this.services;
        }

        public MessagingServiceConfig getService(String name) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getName(), name)).findFirst().orElse(new MessagingServiceConfig(name));
        }

        public List<MessagingServiceConfig> getServicesByKind(String kind) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getKind(), kind)).collect(Collectors.toList());
        }

        public List<MessagingServiceConfig> getServicesByBinding(String binding) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getBinding(), binding) || s.getBinding() == null && Objects.equals(s.getName(), binding)).collect(Collectors.toList());
        }

        public MessagingWebhooks getWebhooks() {
            return this.webhooks;
        }

        public boolean isResetQueues() {
            return this.resetQueues;
        }

        public List<Composite.CompositeServiceConfig.Route> getRoutes() {
            return this.routes;
        }

        public void setWebhooks(MessagingWebhooks webhooks) {
            this.webhooks = webhooks;
        }

        public void setResetQueues(boolean resetQueues) {
            this.resetQueues = resetQueues;
        }

        public void setRoutes(List<Composite.CompositeServiceConfig.Route> routes) {
            this.routes = routes;
        }

        public void setServices(Map<String, MessagingServiceConfig> services) {
            this.services = services;
        }

        public static class MessagingServiceConfig
        extends Enabled {
            private String name;
            private String kind;
            private String binding;
            private String subscribePrefix;
            private String publishPrefix;
            private String format;
            private Connection connection = new Connection();
            private Queue queue = new Queue();
            private Outbox outbox = new Outbox(true);

            public MessagingServiceConfig() {
                super(true);
            }

            public MessagingServiceConfig(String name) {
                super(true);
                this.name = name;
            }

            @Deprecated
            public void setTopicNamespace(String namespace) {
                String normalizedNamespace = namespace;
                if (namespace != null && !namespace.endsWith("/")) {
                    normalizedNamespace = namespace + "/";
                }
                this.subscribePrefix = normalizedNamespace;
            }

            @Deprecated
            public String getTopicNamespace() {
                return this.subscribePrefix;
            }

            public String getName() {
                return this.name;
            }

            public String getKind() {
                return this.kind;
            }

            public String getBinding() {
                return this.binding;
            }

            public String getSubscribePrefix() {
                return this.subscribePrefix;
            }

            public String getPublishPrefix() {
                return this.publishPrefix;
            }

            public String getFormat() {
                return this.format;
            }

            public Connection getConnection() {
                return this.connection;
            }

            public Queue getQueue() {
                return this.queue;
            }

            public Outbox getOutbox() {
                return this.outbox;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setKind(String kind) {
                this.kind = kind;
            }

            public void setBinding(String binding) {
                this.binding = binding;
            }

            public void setSubscribePrefix(String subscribePrefix) {
                this.subscribePrefix = subscribePrefix;
            }

            public void setPublishPrefix(String publishPrefix) {
                this.publishPrefix = publishPrefix;
            }

            public void setFormat(String format) {
                this.format = format;
            }

            public void setConnection(Connection connection) {
                this.connection = connection;
            }

            public void setQueue(Queue queue) {
                this.queue = queue;
            }

            public void setOutbox(Outbox outbox) {
                this.outbox = outbox;
            }

            public static class Outbox
            extends Enabled {
                private Enabled persistent = new Enabled(true);

                public Outbox(Boolean byDefault) {
                    super(byDefault);
                }

                public Enabled getPersistent() {
                    return this.persistent;
                }

                public void setPersistent(Enabled persistent) {
                    this.persistent = persistent;
                }
            }

            public static class Queue {
                private String name;
                private Integer maxFailedAttempts = 0;
                private Map<String, String> config = new HashMap<String, String>();
                private List<String> subscriptions = new ArrayList<String>();

                public String getName() {
                    return this.name;
                }

                public Integer getMaxFailedAttempts() {
                    return this.maxFailedAttempts;
                }

                public Map<String, String> getConfig() {
                    return this.config;
                }

                public List<String> getSubscriptions() {
                    return this.subscriptions;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setMaxFailedAttempts(Integer maxFailedAttempts) {
                    this.maxFailedAttempts = maxFailedAttempts;
                }

                public void setConfig(Map<String, String> config) {
                    this.config = config;
                }

                public void setSubscriptions(List<String> subscriptions) {
                    this.subscriptions = subscriptions;
                }
            }

            public static class Connection {
                private boolean dedicated = false;
                private Map<String, String> properties = new HashMap<String, String>();
                private ConnectionPool connectionPool = new ConnectionPool();

                public boolean isDedicated() {
                    return this.dedicated;
                }

                public Map<String, String> getProperties() {
                    return this.properties;
                }

                public ConnectionPool getConnectionPool() {
                    return this.connectionPool;
                }

                public void setDedicated(boolean dedicated) {
                    this.dedicated = dedicated;
                }

                public void setProperties(Map<String, String> properties) {
                    this.properties = properties;
                }

                public void setConnectionPool(ConnectionPool connectionPool) {
                    this.connectionPool = connectionPool;
                }

                public static class ConnectionPool {
                    private Integer maxConnections = 200;
                    private Integer maxConnectionsPerRoute = 20;

                    public Integer getMaxConnections() {
                        return this.maxConnections;
                    }

                    public Integer getMaxConnectionsPerRoute() {
                        return this.maxConnectionsPerRoute;
                    }

                    public void setMaxConnections(Integer maxConnections) {
                        this.maxConnections = maxConnections;
                    }

                    public void setMaxConnectionsPerRoute(Integer maxConnectionsPerRoute) {
                        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
                    }
                }
            }
        }

        public static class MessagingWebhooks
        extends Enabled {
            private String url;

            public MessagingWebhooks() {
                super(true);
            }

            public String getUrl() {
                return this.url;
            }

            public void setUrl(String url) {
                this.url = url;
            }
        }
    }

    public static class Composite {
        private Map<String, CompositeServiceConfig> services = new HashMap<String, CompositeServiceConfig>();

        public Map<String, CompositeServiceConfig> getServices() {
            this.services.forEach((k, v) -> {
                if (v.getName() == null || v.getName().trim().isEmpty()) {
                    v.setName((String)k);
                }
            });
            return this.services;
        }

        public void setServices(Map<String, CompositeServiceConfig> services) {
            this.services = services;
        }

        public static class CompositeServiceConfig {
            private String name;
            private List<Route> routes = new ArrayList<Route>();

            public CompositeServiceConfig(String name) {
                this.name = name;
            }

            public CompositeServiceConfig() {
            }

            public String getName() {
                return this.name;
            }

            public List<Route> getRoutes() {
                return this.routes;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setRoutes(List<Route> routes) {
                this.routes = routes;
            }

            public static class Route {
                private String service;
                private List<String> events = new ArrayList<String>();

                public String getService() {
                    return this.service;
                }

                public List<String> getEvents() {
                    return this.events;
                }

                public void setService(String service) {
                    this.service = service;
                }

                public void setEvents(List<String> events) {
                    this.events = events;
                }
            }
        }
    }

    public static class ODataV2 {
        private Servlet endpoint = new Servlet("/odata/v2");
        private String edmxPath = "edmx/v2";
        private boolean caseSensitiveFilter = true;

        public Servlet getEndpoint() {
            return this.endpoint;
        }

        public String getEdmxPath() {
            return this.edmxPath;
        }

        public boolean isCaseSensitiveFilter() {
            return this.caseSensitiveFilter;
        }

        public void setEndpoint(Servlet endpoint) {
            this.endpoint = endpoint;
        }

        public void setEdmxPath(String edmxPath) {
            this.edmxPath = edmxPath;
        }

        public void setCaseSensitiveFilter(boolean caseSensitiveFilter) {
            this.caseSensitiveFilter = caseSensitiveFilter;
        }
    }

    public static class ODataV4 {
        private Servlet endpoint = new Servlet("/odata/v4");
        @Deprecated
        private Servlet indexPage = new Servlet("/");
        private boolean contextAbsoluteUrl = false;
        private String edmxPath = "edmx/v4";

        public Servlet getEndpoint() {
            return this.endpoint;
        }

        @Deprecated
        public Servlet getIndexPage() {
            return this.indexPage;
        }

        public boolean isContextAbsoluteUrl() {
            return this.contextAbsoluteUrl;
        }

        public String getEdmxPath() {
            return this.edmxPath;
        }

        public void setEndpoint(Servlet endpoint) {
            this.endpoint = endpoint;
        }

        @Deprecated
        public void setIndexPage(Servlet indexPage) {
            this.indexPage = indexPage;
        }

        public void setContextAbsoluteUrl(boolean contextAbsoluteUrl) {
            this.contextAbsoluteUrl = contextAbsoluteUrl;
        }

        public void setEdmxPath(String edmxPath) {
            this.edmxPath = edmxPath;
        }
    }

    public static class Security {
        private Enabled draftProtection = new Enabled(true);
        private Enabled instanceBasedAuthorization = new Enabled(true);
        private Enabled authorizeAutoExposedEntities = new Enabled(true);
        private boolean logPotentiallySensitive = false;
        private Authentication authentication = new Authentication();
        private Identity identity = new Identity();
        private Xsuaa xsuaa = new Xsuaa();
        private Mock mock = new Mock();

        @Deprecated
        public void setOpenMetadataEndpoints(boolean openMetadataEndpoints) {
            this.authentication.setAuthenticateMetadataEndpoints(!openMetadataEndpoints);
        }

        @Deprecated
        public boolean isOpenMetadataEndpoints() {
            return !this.authentication.isAuthenticateMetadataEndpoints();
        }

        @Deprecated
        public void setAuthenticateUnknownEndpoints(boolean authenticateUnknownEndpoints) {
            this.authentication.setAuthenticateUnknownEndpoints(authenticateUnknownEndpoints);
        }

        @Deprecated
        public boolean isAuthenticateUnknownEndpoints() {
            return this.authentication.isAuthenticateUnknownEndpoints();
        }

        @Deprecated
        public Boolean getOpenUnrestrictedEndpoints() {
            return !"always".equalsIgnoreCase(this.authentication.getMode());
        }

        @Deprecated
        public void setOpenUnrestrictedEndpoints(Boolean openUnrestrictedEndpoints) {
            if (Boolean.FALSE.equals(openUnrestrictedEndpoints)) {
                this.authentication.setMode("always");
            }
        }

        @Deprecated
        public String getDefaultRestrictionLevel() {
            return "never".equalsIgnoreCase(this.authentication.getMode()) || "model-relaxed".equalsIgnoreCase(this.authentication.getMode()) ? "any" : "authenticated-user";
        }

        @Deprecated
        public void setDefaultRestrictionLevel(String defaultRestrictionLevel) {
            if ("any".equalsIgnoreCase(defaultRestrictionLevel) && "model-strict".equalsIgnoreCase(this.authentication.getMode())) {
                this.authentication.setMode("model-relaxed");
            }
        }

        public Enabled getDraftProtection() {
            return this.draftProtection;
        }

        public Enabled getInstanceBasedAuthorization() {
            return this.instanceBasedAuthorization;
        }

        public Enabled getAuthorizeAutoExposedEntities() {
            return this.authorizeAutoExposedEntities;
        }

        public boolean isLogPotentiallySensitive() {
            return this.logPotentiallySensitive;
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        public Identity getIdentity() {
            return this.identity;
        }

        public Xsuaa getXsuaa() {
            return this.xsuaa;
        }

        public Mock getMock() {
            return this.mock;
        }

        public void setDraftProtection(Enabled draftProtection) {
            this.draftProtection = draftProtection;
        }

        public void setInstanceBasedAuthorization(Enabled instanceBasedAuthorization) {
            this.instanceBasedAuthorization = instanceBasedAuthorization;
        }

        public void setAuthorizeAutoExposedEntities(Enabled authorizeAutoExposedEntities) {
            this.authorizeAutoExposedEntities = authorizeAutoExposedEntities;
        }

        public void setLogPotentiallySensitive(boolean logPotentiallySensitive) {
            this.logPotentiallySensitive = logPotentiallySensitive;
        }

        public void setAuthentication(Authentication authentication) {
            this.authentication = authentication;
        }

        public void setIdentity(Identity identity) {
            this.identity = identity;
        }

        public void setXsuaa(Xsuaa xsuaa) {
            this.xsuaa = xsuaa;
        }

        public void setMock(Mock mock) {
            this.mock = mock;
        }

        public static class Mock
        extends Enabled {
            private List<User> users = new ArrayList<User>();
            private Enabled defaultUsers = new Enabled(true);
            private List<Tenant> tenants = new ArrayList<Tenant>();

            public Mock() {
                super(true);
            }

            public List<User> getUsers() {
                if (this.defaultUsers.isEnabled().booleanValue()) {
                    return Stream.concat(this.createDefaultUsers(), this.users.stream()).collect(Collectors.toList());
                }
                return this.users;
            }

            private Stream<User> createDefaultUsers() {
                User authenticated = new User();
                authenticated.setName("authenticated");
                User system = new User();
                system.setName("system");
                system.setSystemUser(true);
                User internal = new User();
                internal.setName("internal");
                internal.setInternalUser(true);
                User privileged = new User();
                privileged.setName("privileged");
                privileged.setPrivileged(true);
                return Stream.of(authenticated, system, internal, privileged);
            }

            public Enabled getDefaultUsers() {
                return this.defaultUsers;
            }

            public List<Tenant> getTenants() {
                return this.tenants;
            }

            public void setUsers(List<User> users) {
                this.users = users;
            }

            public void setDefaultUsers(Enabled defaultUsers) {
                this.defaultUsers = defaultUsers;
            }

            public void setTenants(List<Tenant> tenants) {
                this.tenants = tenants;
            }

            public static class Tenant {
                private String name;
                private List<String> features = new ArrayList<String>();

                public String getName() {
                    return this.name;
                }

                public List<String> getFeatures() {
                    return this.features;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setFeatures(List<String> features) {
                    this.features = features;
                }
            }

            public static class User {
                private String id;
                private String name;
                private String password = "";
                private String tenant;
                private boolean systemUser = false;
                private boolean privileged = false;
                private boolean internalUser = false;
                private List<String> roles = new ArrayList<String>();
                private List<String> features;
                private Map<String, List<String>> attributes = new HashMap<String, List<String>>();
                private List<String> unrestricted = new ArrayList<String>();
                private Map<String, Object> additional = new HashMap<String, Object>();

                public boolean isValid() {
                    return this.getName() != null && !this.getName().isEmpty() && this.getPassword() != null;
                }

                public String getId() {
                    return this.id;
                }

                public String getName() {
                    return this.name;
                }

                public String getPassword() {
                    return this.password;
                }

                public String getTenant() {
                    return this.tenant;
                }

                public boolean isSystemUser() {
                    return this.systemUser;
                }

                public boolean isPrivileged() {
                    return this.privileged;
                }

                public boolean isInternalUser() {
                    return this.internalUser;
                }

                public List<String> getRoles() {
                    return this.roles;
                }

                public List<String> getFeatures() {
                    return this.features;
                }

                public Map<String, List<String>> getAttributes() {
                    return this.attributes;
                }

                public List<String> getUnrestricted() {
                    return this.unrestricted;
                }

                public Map<String, Object> getAdditional() {
                    return this.additional;
                }

                public void setId(String id) {
                    this.id = id;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setPassword(String password) {
                    this.password = password;
                }

                public void setTenant(String tenant) {
                    this.tenant = tenant;
                }

                public void setSystemUser(boolean systemUser) {
                    this.systemUser = systemUser;
                }

                public void setPrivileged(boolean privileged) {
                    this.privileged = privileged;
                }

                public void setInternalUser(boolean internalUser) {
                    this.internalUser = internalUser;
                }

                public void setRoles(List<String> roles) {
                    this.roles = roles;
                }

                public void setFeatures(List<String> features) {
                    this.features = features;
                }

                public void setAttributes(Map<String, List<String>> attributes) {
                    this.attributes = attributes;
                }

                public void setUnrestricted(List<String> unrestricted) {
                    this.unrestricted = unrestricted;
                }

                public void setAdditional(Map<String, Object> additional) {
                    this.additional = additional;
                }
            }
        }

        public static class Xsuaa
        extends Enabled {
            private Enabled authConfig = new Enabled(true);
            private boolean normalizeUserNames = false;
            private String binding;
            private Cache cache = new Cache();

            public Xsuaa() {
                super(true);
            }

            @Deprecated
            public String getServiceName() {
                return this.binding;
            }

            @Deprecated
            public void setServiceName(String binding) {
                this.binding = binding;
            }

            public Enabled getAuthConfig() {
                return this.authConfig;
            }

            public boolean isNormalizeUserNames() {
                return this.normalizeUserNames;
            }

            public String getBinding() {
                return this.binding;
            }

            public Cache getCache() {
                return this.cache;
            }

            public void setAuthConfig(Enabled authConfig) {
                this.authConfig = authConfig;
            }

            public void setNormalizeUserNames(boolean normalizeUserNames) {
                this.normalizeUserNames = normalizeUserNames;
            }

            public void setBinding(String binding) {
                this.binding = binding;
            }

            public void setCache(Cache cache) {
                this.cache = cache;
            }

            public static class Cache
            extends Enabled {
                private int size = 1000;
                private Duration duration = Duration.ofMinutes(10L);
                private Duration tokenRemainingTime = Duration.ofSeconds(30L);

                public Cache() {
                    super(true);
                }

                public int getSize() {
                    return this.size;
                }

                public Duration getDuration() {
                    return this.duration;
                }

                public Duration getTokenRemainingTime() {
                    return this.tokenRemainingTime;
                }

                public void setSize(int size) {
                    this.size = size;
                }

                public void setDuration(Duration duration) {
                    this.duration = duration;
                }

                public void setTokenRemainingTime(Duration tokenRemainingTime) {
                    this.tokenRemainingTime = tokenRemainingTime;
                }
            }
        }

        public static class Identity
        extends Enabled {
            private Enabled authConfig = new Enabled(true);

            public Identity() {
                super(true);
            }

            public Enabled getAuthConfig() {
                return this.authConfig;
            }

            public void setAuthConfig(Enabled authConfig) {
                this.authConfig = authConfig;
            }
        }

        public static class Authentication {
            private String mode = "model-strict";
            private boolean authenticateMetadataEndpoints = true;
            private boolean authenticateUnknownEndpoints = true;

            public String getMode() {
                return this.mode;
            }

            public boolean isAuthenticateMetadataEndpoints() {
                return this.authenticateMetadataEndpoints;
            }

            public boolean isAuthenticateUnknownEndpoints() {
                return this.authenticateUnknownEndpoints;
            }

            public void setMode(String mode) {
                this.mode = mode;
            }

            public void setAuthenticateMetadataEndpoints(boolean authenticateMetadataEndpoints) {
                this.authenticateMetadataEndpoints = authenticateMetadataEndpoints;
            }

            public void setAuthenticateUnknownEndpoints(boolean authenticateUnknownEndpoints) {
                this.authenticateUnknownEndpoints = authenticateUnknownEndpoints;
            }
        }
    }

    public static class Model {
        private String csnPath = "edmx/csn.json";
        private Enabled universalCsn = new Enabled(false);
        private Provider provider = new Provider();

        public String getCsnPath() {
            return this.csnPath;
        }

        public Enabled getUniversalCsn() {
            return this.universalCsn;
        }

        public Provider getProvider() {
            return this.provider;
        }

        public void setCsnPath(String csnPath) {
            this.csnPath = csnPath;
        }

        public void setUniversalCsn(Enabled universalCsn) {
            this.universalCsn = universalCsn;
        }

        public void setProvider(Provider provider) {
            this.provider = provider;
        }

        public static class Provider {
            String url;
            private MultiTenancy.Sidecar.Cache cache = new MultiTenancy.Sidecar.Cache();

            public String getUrl() {
                return this.url;
            }

            public MultiTenancy.Sidecar.Cache getCache() {
                return this.cache;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public void setCache(MultiTenancy.Sidecar.Cache cache) {
                this.cache = cache;
            }
        }
    }

    public static class DataSource {
        private Enabled autoConfig = new Enabled(true);
        private boolean embedded;
        private String binding;
        private String csvInitializationMode = "embedded";
        private String csvFileSuffix = ".csv";
        private List<String> csvPaths = Arrays.asList("db/data/**", "db/csv/**", "../db/data/**", "../db/csv/**");
        private boolean csvSingleChangeset;

        @Deprecated
        public String getServiceName() {
            return this.binding;
        }

        @Deprecated
        public void setServiceName(String binding) {
            this.binding = binding;
        }

        public Enabled getAutoConfig() {
            return this.autoConfig;
        }

        public boolean isEmbedded() {
            return this.embedded;
        }

        public String getBinding() {
            return this.binding;
        }

        public String getCsvInitializationMode() {
            return this.csvInitializationMode;
        }

        public String getCsvFileSuffix() {
            return this.csvFileSuffix;
        }

        public List<String> getCsvPaths() {
            return this.csvPaths;
        }

        public boolean isCsvSingleChangeset() {
            return this.csvSingleChangeset;
        }

        public void setAutoConfig(Enabled autoConfig) {
            this.autoConfig = autoConfig;
        }

        public void setEmbedded(boolean embedded) {
            this.embedded = embedded;
        }

        public void setBinding(String binding) {
            this.binding = binding;
        }

        public void setCsvInitializationMode(String csvInitializationMode) {
            this.csvInitializationMode = csvInitializationMode;
        }

        public void setCsvFileSuffix(String csvFileSuffix) {
            this.csvFileSuffix = csvFileSuffix;
        }

        public void setCsvPaths(List<String> csvPaths) {
            this.csvPaths = csvPaths;
        }

        public void setCsvSingleChangeset(boolean csvSingleChangeset) {
            this.csvSingleChangeset = csvSingleChangeset;
        }
    }

    public static class Environment {
        private Local local = new Local();
        private K8s k8s = new K8s();

        public Local getLocal() {
            return this.local;
        }

        public K8s getK8s() {
            return this.k8s;
        }

        public void setLocal(Local local) {
            this.local = local;
        }

        public void setK8s(K8s k8s) {
            this.k8s = k8s;
        }

        public static class K8s {
            private String secretsPath = "/etc/secrets/sapcp";
            private Map<String, ServiceBindingConfig> serviceBindings = new HashMap<String, ServiceBindingConfig>();

            public Map<String, ServiceBindingConfig> getServiceBindings() {
                this.serviceBindings.forEach((k, v) -> {
                    if (v.getName() == null || v.getName().trim().isEmpty()) {
                        v.setName((String)k);
                    }
                });
                return this.serviceBindings;
            }

            public String getSecretsPath() {
                return this.secretsPath;
            }

            public void setSecretsPath(String secretsPath) {
                this.secretsPath = secretsPath;
            }

            public void setServiceBindings(Map<String, ServiceBindingConfig> serviceBindings) {
                this.serviceBindings = serviceBindings;
            }

            public static class ServiceBindingConfig {
                private String name;
                private String secretsPath;
                private String service;
                private String plan;
                private List<String> tags;

                public String getName() {
                    return this.name;
                }

                public String getSecretsPath() {
                    return this.secretsPath;
                }

                public String getService() {
                    return this.service;
                }

                public String getPlan() {
                    return this.plan;
                }

                public List<String> getTags() {
                    return this.tags;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setSecretsPath(String secretsPath) {
                    this.secretsPath = secretsPath;
                }

                public void setService(String service) {
                    this.service = service;
                }

                public void setPlan(String plan) {
                    this.plan = plan;
                }

                public void setTags(List<String> tags) {
                    this.tags = tags;
                }
            }
        }

        public static class Local {
            private String defaultEnvPath;

            public String getDefaultEnvPath() {
                return this.defaultEnvPath;
            }

            public void setDefaultEnvPath(String defaultEnvPath) {
                this.defaultEnvPath = defaultEnvPath;
            }
        }
    }
}

