/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.messages;

import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.CoreFactory;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.messages.MessageTarget;
import java.util.function.Function;

public interface Message {
    public static Message create(Severity severity, String text) {
        return CoreFactory.INSTANCE.createMessage(severity, text);
    }

    public static Message create(Severity severity, String text, Message message) {
        return CoreFactory.INSTANCE.createMessage(severity, text, message);
    }

    public static Message create(String text, ServiceException exception) {
        return CoreFactory.INSTANCE.createMessage(text, exception);
    }

    public String getCode();

    public String getMessage();

    public MessageTarget getTarget();

    public String getLongTextUrl();

    public Severity getSeverity();

    public Message longTextUrl(String var1);

    public Message code(String var1);

    public Message target(String var1);

    public Message target(Function<StructuredType<?>, Object> var1);

    public Message target(String var1, Function<StructuredType<?>, Object> var2);

    @Deprecated
    public Message target(String var1, String var2, Function<StructuredType<?>, Object> var3);

    public <E extends StructuredType<E>> Message target(Class<E> var1, Function<E, Object> var2);

    public <E extends StructuredType<E>> Message target(String var1, Class<E> var2, Function<E, Object> var3);

    public Message target(Path var1, CdsElement var2);

    public static enum Severity {
        SUCCESS(1),
        INFO(2),
        WARNING(3),
        ERROR(4);

        private final int numericSeverity;

        private Severity(int numericSeverity) {
            this.numericSeverity = numericSeverity;
        }

        public int getNumericSeverity() {
            return this.numericSeverity;
        }
    }
}

