/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.runtime;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.environment.CdsEnvironment;
import com.sap.cds.services.request.FeatureToggle;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.ChangeSetContextRunner;
import com.sap.cds.services.runtime.Request;
import com.sap.cds.services.runtime.RequestContextRunner;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;

public interface CdsRuntime {
    public CdsEnvironment getEnvironment();

    public ServiceCatalog getServiceCatalog();

    public CdsModel getCdsModel();

    default public CdsModel getCdsModel(String tenant) {
        return this.getCdsModel(UserInfo.create().setTenant(tenant), FeatureTogglesInfo.create(new FeatureToggle[0]));
    }

    public CdsModel getCdsModel(UserInfo var1, FeatureTogglesInfo var2);

    public ParameterInfo getProvidedParameterInfo();

    public UserInfo getProvidedUserInfo();

    public AuthenticationInfo getProvidedAuthenticationInfo();

    public FeatureTogglesInfo getFeatureTogglesInfo(UserInfo var1, ParameterInfo var2);

    public String getLocalizedMessage(String var1, Object[] var2, Locale var3);

    @Deprecated
    public <T> T runInRequestContext(Request var1, Function<RequestContext, T> var2);

    @Deprecated
    default public void runInRequestContext(Request request, Consumer<RequestContext> requestHandler) {
        this.runInRequestContext(request, (RequestContext requestContext) -> {
            requestHandler.accept((RequestContext)requestContext);
            return Void.TYPE;
        });
    }

    public RequestContextRunner requestContext();

    @Deprecated
    public <T> T runInChangeSetContext(Function<ChangeSetContext, T> var1);

    @Deprecated
    default public void runInChangeSetContext(Consumer<ChangeSetContext> changeSetHandler) {
        this.runInChangeSetContext((ChangeSetContext changeSetContext) -> {
            changeSetHandler.accept((ChangeSetContext)changeSetContext);
            return Void.TYPE;
        });
    }

    public ChangeSetContextRunner changeSetContext();
}

