/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services;

import com.sap.cds.services.CoreFactory;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.handler.Handler;

public abstract class ServiceDelegator
implements Service {
    private final Service service;

    protected ServiceDelegator(String name) {
        this.service = CoreFactory.INSTANCE.createService(name, this);
    }

    @Override
    public void before(String[] events, String[] entities, int order, Handler handler) {
        this.service.before(events, entities, order, handler);
    }

    @Override
    public void on(String[] events, String[] entities, int order, Handler handler) {
        this.service.on(events, entities, order, handler);
    }

    @Override
    public void after(String[] events, String[] entities, int order, Handler handler) {
        this.service.after(events, entities, order, handler);
    }

    @Override
    public void emit(EventContext context) {
        this.service.emit(context);
    }

    @Override
    public String getName() {
        return this.service.getName();
    }

    public Service getDelegatedService() {
        return this.service;
    }
}

