/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.draft;

import java.util.Map;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

/**
 * The {@link EventContext} for the {@link DraftService#EVENT_DRAFT_READ} event
 */
@EventName(DraftService.EVENT_DRAFT_READ)
public interface DraftReadEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlayed with this interface. The event is set to be {@link DraftService#EVENT_DRAFT_READ}
	 * @param entityName the name of the entity
	 * @return the {@link DraftReadEventContext}
	 */
	static DraftReadEventContext create(String entityName) {
		return EventContext.create(DraftReadEventContext.class, entityName);
	}

	@Override
	DraftService getService();

	// IN
	/**
	 * @return the {@link CqnSelect} statement
	 */
	CqnSelect getCqn();

	/**
	 * Sets the {@link CqnSelect} statement
	 * @param cqn the {@link CqnSelect} statement
	 */
	void setCqn(CqnSelect cqn);

	/**
	 * The CQN named values, for parameterized {@link CqnSelect} statements
	 * @return the CQN named values
	 */
	Map<String, Object> getCqnNamedValues();

	/**
	 * Sets the CQN named values, for parameterized {@link CqnSelect} statements
	 * @param namedValues the CQN named values
	 */
	void setCqnNamedValues(Map<String, Object> namedValues);

	// OUT
	/**
	 * @return the {@link Result} of the {@link DraftService#EVENT_DRAFT_READ} event
	 */
	Result getResult();

	/**
	 * Sets the result of the {@link DraftService#EVENT_DRAFT_READ} event
	 * @param result a {@link Result} or a list of Maps, which will be transformed into a {@link Result}
	 */
	void setResult(Iterable<? extends Map<String, ?>> result);

}
