/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services;

/**
 * An {@link ErrorStatus} is used by {@link ServiceException} to identify certain error types.
 * The error type is defined by an internal error code ({@link #getCodeString()}).
 * It also suggests a mapping for the well-known status codes defined by the HTTP protocol ({@link #getHttpStatus()}).
 */
public interface ErrorStatus {

	/**
	 * @return The internal error code
	 */
	String getCodeString();

	/**
	 * @return The error description
	 */
	default String getDescription() {
		return getCodeString();
	}

	/**
	 * @return The suggested mapping to a HTTP status code
	 */
	int getHttpStatus();

}
