/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.auditlog;

import java.util.Collection;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;

@CdsName("com.sap.cds.services.auditlog.DataModification")
public interface DataModification extends CdsData {
  String OBJECT = "object";

  String DATA_SUBJECT = "dataSubject";

  String ACTION = "action";

  String ATTRIBUTES = "attributes";

  /**
   * The object where the modified personal data that is being
   * audit logged is contained.
   */
  DataObject getDataObject();

  /**
   * The object where the modified personal data that is being
   * audit logged is contained.
   */
  void setDataObject(DataObject object);

  /**
   * The data subject whom the modified personal data that is
   * being audit logged belongs to.
   */
  DataSubject getDataSubject();

  /**
   * The data subject whom the modified personal data that is
   * being audit logged belongs to.
   */
  void setDataSubject(DataSubject dataSubject);

  /**
   * The action that was performed: Create, Update, Delete.
   */
  Action getAction();

  /**
   * The action that was performed: Create, Update, Delete.
   */
  void setAction(Action action);

  /**
   * A list with changed attributes.
   */
  Collection<ChangedAttribute> getAttributes();

  /**
   * A list with changed attributes.
   */
  void setAttributes(Collection<ChangedAttribute> attributes);

  static DataModification create() {
    return Struct.create(DataModification.class);
  }
}
