/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.authorization;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

@EventName(AuthorizationService.EVENT_FUNCTION_ACCESS)
public interface FunctionAccessEventContext extends EventContext {

	static FunctionAccessEventContext create() {
		return EventContext.create(FunctionAccessEventContext.class, null);
	}

	@Override
	AuthorizationService getService();

	// IN
	void setFunctionName(String functionName);

	String getFunctionName();

	void setEntityName(String event);

	String getEntityName(); // optional


	// OUT
	Boolean getResult();

	void setResult(boolean result);
}
