/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.changeset;

/**
 * Listener interface to get notified when a {@link ChangeSetContext} is closed successfully or cancelled.
 */
public interface ChangeSetListener {

	/**
	 * Called, before the {@link ChangeSetContext} is closed.
	 */
	default void beforeClose() {
	}

	/**
	 * Called, after the {@link ChangeSetContext} is closed.
	 * @param completed true, if the {@link ChangeSetContext} was closed successfully, false if {@link ChangeSetContext#markForCancel()} was set, or the closing itself failed.
	 */
	default void afterClose(boolean completed) {
	}
}
