/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.datasource;

import java.util.List;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;

/**
 * Interface for providers of {@link DataSourceDescriptor}.
 * Implementing classes can get access to the {@link CdsRuntime} by implementing {@link CdsRuntimeAware}.
 */
public interface DataSourceDescriptorFactory {

	/**
	 * @return a list of {@link DataSourceDescriptor}
	 */
	List<DataSourceDescriptor> create();

}
