/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.messages;

import com.sap.cds.ql.cqn.CqnReference;

public interface MessageTarget {

	/**
     * Constant specifying a message target parameter, referring to the CQN of an
     * event context.
     * 
     * This is used to decide whether a binding parameter is required for the
     * message target output.
     */
    String PARAMETER_CQN = "cqn";

	/**
	 * @return the CQN reference of the message target
	 */
	CqnReference getRef();

	/**
	 * @return (target) parameter of the message target
	 */
	String getParameter();

}
