/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

@EventName(ExtensibilityService.EVENT_MODEL_CHANGED)
public interface ModelChangedEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlayed with this interface. The event is set to be
	 * {@link ExtensibilityService#EVENT_MODEL_CHANGED}
	 * @return the {@link ModelChangedEventContext}
	 */
	static ModelChangedEventContext create() {
		return EventContext.create(ModelChangedEventContext.class, null);
	}

	/**
	 * Sets the optional timestamp of the model change
	 * @param timestamp The timestamp of the model change in epoch time
	 */
	void setTimestamp(Long timestamp);

	/**
	 * @return The timestamp of the model change in epoch time or {@code null} if no timestamp was specified
	 */
	Long getTimestamp();

}