/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt;

import java.util.List;
import java.util.stream.Collectors;

import com.sap.cds.services.Service;

/**
 * Interface for a {@link Service} that provides tenant information.
 */
public interface TenantProviderService extends Service {

	static final String DEFAULT_NAME = "TenantProviderService$Default";
	static final String EVENT_READ_TENANTS = "READ_TENANTS";
	static final String EVENT_READ_PROVIDER_TENANT = "READ_PROVIDER_TENANT";

	/**
	 * @return A list of tenant identifiers that are currently subscribed to this application.
	 * In single tenant scenario the list contains a single {@code null} value representing the provider tenant.
	 */
	default List<String> readTenants() {
		return readTenantsInfo().stream().map(TenantInfo::getTenant).collect(Collectors.toList());
	}

	/**
	 * @return A list of {@link TenantInfo} for all tenants that are currently subscribed to this application.
	 * In single tenant scenario the list contains a single {@code TenantInfo} object with tenant {@code null} representing the provider tenant.
	 */
	List<TenantInfo> readTenantsInfo();

	/**
	 * @return The tenant identifier of the tenant that provides this application.
	 * In single tenant scenario the value {@code null} is returned.
	 */
	String readProviderTenant();

}
