/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.pdf;

import java.io.OutputStream;
import java.util.Map;

import com.sap.cds.services.Service;

/**
 * PDF export service
 */
public interface PdfService extends Service {

    final String DEFAULT_NAME = "PdfService$Default";
    final String EVENT_EXPORT = "EXPORT";

    /**
     * Write the rows of data to a PDF and send it to client via output stream
     * 
     * @param docDescHeader PDF document description
     * @param data          rows of data to be written
     * @param out           output stream
     */
    void export(PdfDocumentDescription docDescHeader, Iterable<? extends Map<String, ?>> data, OutputStream out);

}
