/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.runtime;

import java.util.function.Consumer;
import java.util.function.Function;

import com.sap.cds.services.changeset.ChangeSetContext;

public interface ChangeSetContextRunner {

	/**
	 * Opens a {@link ChangeSetContext} and runs the given handler within its scope.
	 * The {@code ChangeSetContext} marks a scope in which all opened transactions
	 * etc. are committed cancelled together. Note that single transactions may fail
	 * during commit but others might be successful.
	 * <p>
	 * The {@code ChangeSetContext} will be propagated to all
	 * {@link com.sap.cds.services.EventContext} instances in the service call
	 * hierarchy.
	 *
	 * @param <T>              The type of the response
	 * @param changeSetHandler The handler for processing the request within the context
	 * @return A generic response object of the handler
	 */
	<T> T run(Function<ChangeSetContext, T> changeSetHandler);

	/**
	 * Opens a {@link ChangeSetContext} and runs the given handler within its scope.
	 * The {@code ChangeSetContext} marks a scope in which all opened transactions
	 * etc. are committed cancelled together. Note that single transactions may fail
	 * during commit but others might be successful.
	 * <p>
	 * The {@code ChangeSetContext} will be propagated to all
	 * {@link com.sap.cds.services.EventContext} instances in the service call
	 * hierarchy.
	 *
	 * @param changeSetHandler The handler for processing the request within the context
	 */
	void run(Consumer<ChangeSetContext> changeSetHandler);

}
