/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.outbox;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;

public interface StoredRequestContext extends CdsData {

	/**
	 * Creates a new {@link StoredRequestContext}
	 * @return the {@link StoredRequestContext}
	 */
	static StoredRequestContext create() {
		return Struct.create(StoredRequestContext.class);
	}

	/**
	 * @return the tenant ID
	 */
	String getTenant();

	/**
	 * Sets the tenant ID.
	 * @param tenant the tenant ID
	 */
	void setTenant(String tenant);

	/**
	 * @return true, if the user is a privileged user
	 */
	Boolean getIsPrivileged();

	/**
	 * @param isPrivileged true, if the user is a privileged user
	 */
	void setIsPrivileged(Boolean isPrivileged);

	/**
	 * @return the correlation ID
	 */
	String getCorrelationId();

	/**
	 * Sets the correlation ID.
	 * @param correlationId the correlation ID
	 */
	void setCorrelationId(String correlationId);

	/**
	 * @return the locale
	 */
	String getLocale();

	/**
	 * Sets the locale.
	 * @param locale the locale
	 */
	void setLocale(String locale);

	/**
	 * @return the valid from timestamp
	 */
	String getValidFrom();

	/**
	 * Sets the valid from timestamp.
	 * @param validFrom the valid to timestamp
	 */
	void setValidFrom(String validFrom);

	/**
	 * @return the valid to timestamp
	 */
	String getValidTo();

	/**
	 * Sets the valid to timestamp.
	 * @param validTo the valid to timestamp
	 */
	void setValidTo(String validTo);

}
