/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.authorization;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

@EventName(AuthorizationService.EVENT_SERVICE_ACCESS)
public interface ServiceAccessEventContext extends EventContext {

	static ServiceAccessEventContext create() {
		return EventContext.create(ServiceAccessEventContext.class, null);
	}

	@Override
	AuthorizationService getService();

	// IN
	void setAccessServiceName(String service);

	String getAccessServiceName();

	void setAccessEventName(String event);

	String getAccessEventName();

	// OUT
	Boolean getResult();

	void setResult(boolean result);
}
