/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.environment;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class CdsProperties {
    private Environment environment = new Environment();
    private DataSource dataSource = new DataSource();
    private Model model = new Model();
    private Security security = new Security();
    private Servlet indexPage = new Servlet("/", true);
    private ODataV4 odataV4 = new ODataV4();
    private ODataV2 odataV2 = new ODataV2();
    private Hcql hcql = new Hcql();
    private Messaging messaging = new Messaging();
    private MultiTenancy multiTenancy = new MultiTenancy();
    private Persistence persistence = new Persistence();
    private Application application = new Application();
    private Remote remote = new Remote();
    private Locales locales = new Locales();
    private Errors errors = new Errors();
    private Drafts drafts = new Drafts();
    private Query query = new Query();
    private Sql sql = new Sql();
    private AuditLog auditLog = new AuditLog();
    private Outbox outbox = new Outbox();
    private CloudSdk cloudSdk = new CloudSdk();

    public Environment getEnvironment() {
        return this.environment;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Model getModel() {
        return this.model;
    }

    public Security getSecurity() {
        return this.security;
    }

    public Servlet getIndexPage() {
        return this.indexPage;
    }

    public ODataV4 getOdataV4() {
        return this.odataV4;
    }

    public ODataV2 getOdataV2() {
        return this.odataV2;
    }

    public Hcql getHcql() {
        return this.hcql;
    }

    public Messaging getMessaging() {
        return this.messaging;
    }

    public MultiTenancy getMultiTenancy() {
        return this.multiTenancy;
    }

    public Persistence getPersistence() {
        return this.persistence;
    }

    public Application getApplication() {
        return this.application;
    }

    public Remote getRemote() {
        return this.remote;
    }

    public Locales getLocales() {
        return this.locales;
    }

    public Errors getErrors() {
        return this.errors;
    }

    public Drafts getDrafts() {
        return this.drafts;
    }

    public Query getQuery() {
        return this.query;
    }

    public Sql getSql() {
        return this.sql;
    }

    public AuditLog getAuditLog() {
        return this.auditLog;
    }

    public Outbox getOutbox() {
        return this.outbox;
    }

    public CloudSdk getCloudSdk() {
        return this.cloudSdk;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public void setIndexPage(Servlet indexPage) {
        this.indexPage = indexPage;
    }

    public void setOdataV4(ODataV4 odataV4) {
        this.odataV4 = odataV4;
    }

    public void setOdataV2(ODataV2 odataV2) {
        this.odataV2 = odataV2;
    }

    public void setHcql(Hcql hcql) {
        this.hcql = hcql;
    }

    public void setMessaging(Messaging messaging) {
        this.messaging = messaging;
    }

    public void setMultiTenancy(MultiTenancy multiTenancy) {
        this.multiTenancy = multiTenancy;
    }

    public void setPersistence(Persistence persistence) {
        this.persistence = persistence;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public void setRemote(Remote remote) {
        this.remote = remote;
    }

    public void setLocales(Locales locales) {
        this.locales = locales;
    }

    public void setErrors(Errors errors) {
        this.errors = errors;
    }

    public void setDrafts(Drafts drafts) {
        this.drafts = drafts;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void setSql(Sql sql) {
        this.sql = sql;
    }

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public void setOutbox(Outbox outbox) {
        this.outbox = outbox;
    }

    public void setCloudSdk(CloudSdk cloudSdk) {
        this.cloudSdk = cloudSdk;
    }

    public static class Environment {
        private Local local = new Local();
        private Enabled command = new Enabled(false);
        private K8s k8s = new K8s();

        public Local getLocal() {
            return this.local;
        }

        public Enabled getCommand() {
            return this.command;
        }

        public K8s getK8s() {
            return this.k8s;
        }

        public void setLocal(Local local) {
            this.local = local;
        }

        public void setCommand(Enabled command) {
            this.command = command;
        }

        public void setK8s(K8s k8s) {
            this.k8s = k8s;
        }

        public static class Local {
            private String defaultEnvPath;

            public String getDefaultEnvPath() {
                return this.defaultEnvPath;
            }

            public void setDefaultEnvPath(String defaultEnvPath) {
                this.defaultEnvPath = defaultEnvPath;
            }
        }

        public static class K8s {
            private String secretsPath = "/etc/secrets/sapcp";
            private Map<String, ServiceBindingConfig> serviceBindings = new HashMap<String, ServiceBindingConfig>();

            public Map<String, ServiceBindingConfig> getServiceBindings() {
                this.serviceBindings.forEach((k, v) -> {
                    if (v.getName() == null || v.getName().trim().isEmpty()) {
                        v.setName((String)k);
                    }
                });
                return this.serviceBindings;
            }

            public String getSecretsPath() {
                return this.secretsPath;
            }

            public void setSecretsPath(String secretsPath) {
                this.secretsPath = secretsPath;
            }

            public void setServiceBindings(Map<String, ServiceBindingConfig> serviceBindings) {
                this.serviceBindings = serviceBindings;
            }

            public static class ServiceBindingConfig {
                private String name;
                private String secretsPath;
                private String service;
                private String plan;
                private List<String> tags;

                public String getName() {
                    return this.name;
                }

                public String getSecretsPath() {
                    return this.secretsPath;
                }

                public String getService() {
                    return this.service;
                }

                public String getPlan() {
                    return this.plan;
                }

                public List<String> getTags() {
                    return this.tags;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setSecretsPath(String secretsPath) {
                    this.secretsPath = secretsPath;
                }

                public void setService(String service) {
                    this.service = service;
                }

                public void setPlan(String plan) {
                    this.plan = plan;
                }

                public void setTags(List<String> tags) {
                    this.tags = tags;
                }
            }
        }
    }

    public static class DataSource {
        private Csv csv = new Csv();
        private Enabled autoConfig = new Enabled(true);
        private boolean embedded;
        private String binding;

        @Deprecated
        public String getCsvInitializationMode() {
            return this.csv.getInitializationMode();
        }

        @Deprecated
        public void setCsvInitializationMode(String csvInitializationMode) {
            this.csv.setInitializationMode(csvInitializationMode);
        }

        @Deprecated
        public String getCsvFileSuffix() {
            return this.csv.getFileSuffix();
        }

        @Deprecated
        public void setCsvFileSuffix(String csvFileSuffix) {
            this.csv.setFileSuffix(csvFileSuffix);
        }

        @Deprecated
        public List<String> getCsvPaths() {
            return this.csv.getPaths();
        }

        @Deprecated
        public void setCsvPaths(List<String> csvPaths) {
            this.csv.setPaths(csvPaths);
        }

        @Deprecated
        public boolean isCsvSingleChangeset() {
            return this.csv.isSingleChangeset();
        }

        @Deprecated
        public void setCsvSingleChangeset(boolean csvSingleChangeset) {
            this.csv.setSingleChangeset(csvSingleChangeset);
        }

        public Csv getCsv() {
            return this.csv;
        }

        public Enabled getAutoConfig() {
            return this.autoConfig;
        }

        public boolean isEmbedded() {
            return this.embedded;
        }

        public String getBinding() {
            return this.binding;
        }

        public void setCsv(Csv csv) {
            this.csv = csv;
        }

        public void setAutoConfig(Enabled autoConfig) {
            this.autoConfig = autoConfig;
        }

        public void setEmbedded(boolean embedded) {
            this.embedded = embedded;
        }

        public void setBinding(String binding) {
            this.binding = binding;
        }

        public static class Csv {
            private String initializationMode = "embedded";
            private String fileSuffix = ".csv";
            private List<String> paths = Arrays.asList("db/data/**", "db/csv/**", "../db/data/**", "../db/csv/**");
            private boolean singleChangeset;

            public String getInitializationMode() {
                return this.initializationMode;
            }

            public String getFileSuffix() {
                return this.fileSuffix;
            }

            public List<String> getPaths() {
                return this.paths;
            }

            public boolean isSingleChangeset() {
                return this.singleChangeset;
            }

            public void setInitializationMode(String initializationMode) {
                this.initializationMode = initializationMode;
            }

            public void setFileSuffix(String fileSuffix) {
                this.fileSuffix = fileSuffix;
            }

            public void setPaths(List<String> paths) {
                this.paths = paths;
            }

            public void setSingleChangeset(boolean singleChangeset) {
                this.singleChangeset = singleChangeset;
            }
        }
    }

    public static class Model {
        private String csnPath = "edmx/csn.json";
        private Enabled universalCsn = new Enabled(false);
        private Provider provider = new Provider();
        private boolean includeUiAnnotations = false;

        public String getCsnPath() {
            return this.csnPath;
        }

        public Enabled getUniversalCsn() {
            return this.universalCsn;
        }

        public Provider getProvider() {
            return this.provider;
        }

        public boolean isIncludeUiAnnotations() {
            return this.includeUiAnnotations;
        }

        public void setCsnPath(String csnPath) {
            this.csnPath = csnPath;
        }

        public void setUniversalCsn(Enabled universalCsn) {
            this.universalCsn = universalCsn;
        }

        public void setProvider(Provider provider) {
            this.provider = provider;
        }

        public void setIncludeUiAnnotations(boolean includeUiAnnotations) {
            this.includeUiAnnotations = includeUiAnnotations;
        }

        public static class Provider {
            String url;
            private MultiTenancy.Sidecar.Cache cache = new MultiTenancy.Sidecar.Cache();

            public String getUrl() {
                return this.url;
            }

            public MultiTenancy.Sidecar.Cache getCache() {
                return this.cache;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public void setCache(MultiTenancy.Sidecar.Cache cache) {
                this.cache = cache;
            }
        }
    }

    public static class Security {
        private boolean logPotentiallySensitive = false;
        private Authentication authentication = new Authentication();
        private Authorization authorization = new Authorization();
        private Identity identity = new Identity();
        private Xsuaa xsuaa = new Xsuaa();
        private Mock mock = new Mock();

        public boolean isLogPotentiallySensitive() {
            return this.logPotentiallySensitive;
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        public Authorization getAuthorization() {
            return this.authorization;
        }

        public Identity getIdentity() {
            return this.identity;
        }

        public Xsuaa getXsuaa() {
            return this.xsuaa;
        }

        public Mock getMock() {
            return this.mock;
        }

        public void setLogPotentiallySensitive(boolean logPotentiallySensitive) {
            this.logPotentiallySensitive = logPotentiallySensitive;
        }

        public void setAuthentication(Authentication authentication) {
            this.authentication = authentication;
        }

        public void setAuthorization(Authorization authorization) {
            this.authorization = authorization;
        }

        public void setIdentity(Identity identity) {
            this.identity = identity;
        }

        public void setXsuaa(Xsuaa xsuaa) {
            this.xsuaa = xsuaa;
        }

        public void setMock(Mock mock) {
            this.mock = mock;
        }

        public static class Authentication {
            private String mode = "model-strict";
            private boolean authenticateMetadataEndpoints = true;
            private boolean authenticateUnknownEndpoints = true;
            private boolean normalizeProviderTenant = true;
            private Enabled authConfig = new Enabled(true);

            public String getMode() {
                return this.mode;
            }

            public boolean isAuthenticateMetadataEndpoints() {
                return this.authenticateMetadataEndpoints;
            }

            public boolean isAuthenticateUnknownEndpoints() {
                return this.authenticateUnknownEndpoints;
            }

            public boolean isNormalizeProviderTenant() {
                return this.normalizeProviderTenant;
            }

            public Enabled getAuthConfig() {
                return this.authConfig;
            }

            public void setMode(String mode) {
                this.mode = mode;
            }

            public void setAuthenticateMetadataEndpoints(boolean authenticateMetadataEndpoints) {
                this.authenticateMetadataEndpoints = authenticateMetadataEndpoints;
            }

            public void setAuthenticateUnknownEndpoints(boolean authenticateUnknownEndpoints) {
                this.authenticateUnknownEndpoints = authenticateUnknownEndpoints;
            }

            public void setNormalizeProviderTenant(boolean normalizeProviderTenant) {
                this.normalizeProviderTenant = normalizeProviderTenant;
            }

            public void setAuthConfig(Enabled authConfig) {
                this.authConfig = authConfig;
            }
        }

        public static class Authorization
        extends Enabled {
            private Enabled draftProtection = new Enabled(true);
            private boolean emptyAttributeValuesAreRestricted = true;

            public Authorization() {
                super(true);
            }

            public Enabled getDraftProtection() {
                return this.draftProtection;
            }

            public boolean isEmptyAttributeValuesAreRestricted() {
                return this.emptyAttributeValuesAreRestricted;
            }

            public void setDraftProtection(Enabled draftProtection) {
                this.draftProtection = draftProtection;
            }

            public void setEmptyAttributeValuesAreRestricted(boolean emptyAttributeValuesAreRestricted) {
                this.emptyAttributeValuesAreRestricted = emptyAttributeValuesAreRestricted;
            }
        }

        public static class Identity
        extends Enabled {
            @Deprecated
            private Enabled authConfig = new Enabled(true);
            private String binding;

            public Identity() {
                super(true);
            }

            @Deprecated
            public Enabled getAuthConfig() {
                return this.authConfig;
            }

            public String getBinding() {
                return this.binding;
            }

            @Deprecated
            public void setAuthConfig(Enabled authConfig) {
                this.authConfig = authConfig;
            }

            public void setBinding(String binding) {
                this.binding = binding;
            }
        }

        public static class Xsuaa
        extends Enabled {
            @Deprecated
            private Enabled authConfig = new Enabled(true);
            private String binding;

            public Xsuaa() {
                super(true);
            }

            @Deprecated
            public Enabled getAuthConfig() {
                return this.authConfig;
            }

            public String getBinding() {
                return this.binding;
            }

            @Deprecated
            public void setAuthConfig(Enabled authConfig) {
                this.authConfig = authConfig;
            }

            public void setBinding(String binding) {
                this.binding = binding;
            }
        }

        public static class Mock
        extends Enabled {
            private Map<String, User> users = new HashMap<String, User>();
            private Enabled defaultUsers = new Enabled(true);
            private Map<String, Tenant> tenants = new HashMap<String, Tenant>();

            public Mock() {
                super(true);
            }

            public Map<String, User> getUsers() {
                this.users.forEach((k, v) -> {
                    if (v.getName() == null || v.getName().trim().isEmpty()) {
                        v.setName((String)k);
                    }
                });
                if (this.defaultUsers.isEnabled().booleanValue()) {
                    return this.withDefaultUsers(this.users);
                }
                return this.users;
            }

            private Map<String, User> withDefaultUsers(Map<String, User> configured) {
                HashMap<String, User> users = new HashMap<String, User>(configured);
                User authenticated = new User();
                authenticated.setName("authenticated");
                users.put("authenticated", authenticated);
                User system = new User();
                system.setName("system");
                system.setSystemUser(true);
                users.put("system", system);
                User internal = new User();
                internal.setName("internal");
                internal.setInternalUser(true);
                users.put("internal", internal);
                User privileged = new User();
                privileged.setName("privileged");
                privileged.setPrivileged(true);
                users.put("privileged", privileged);
                return users;
            }

            public Map<String, Tenant> getTenants() {
                this.tenants.forEach((k, v) -> {
                    if (v.getName() == null || v.getName().trim().isEmpty()) {
                        v.setName((String)k);
                    }
                });
                return this.tenants;
            }

            public Enabled getDefaultUsers() {
                return this.defaultUsers;
            }

            public void setUsers(Map<String, User> users) {
                this.users = users;
            }

            public void setDefaultUsers(Enabled defaultUsers) {
                this.defaultUsers = defaultUsers;
            }

            public void setTenants(Map<String, Tenant> tenants) {
                this.tenants = tenants;
            }

            public static class User {
                private String id;
                private String name;
                private String password = "";
                private String tenant;
                private boolean systemUser = false;
                private boolean privileged = false;
                private boolean internalUser = false;
                private List<String> roles = new ArrayList<String>();
                private List<String> features;
                private Map<String, List<String>> attributes = new HashMap<String, List<String>>();
                @Deprecated
                private List<String> unrestricted = new ArrayList<String>();
                private Map<String, Object> additional = new HashMap<String, Object>();

                public boolean isValid() {
                    return this.getName() != null && !this.getName().isEmpty() && this.getPassword() != null;
                }

                public String getId() {
                    return this.id;
                }

                public String getName() {
                    return this.name;
                }

                public String getPassword() {
                    return this.password;
                }

                public String getTenant() {
                    return this.tenant;
                }

                public boolean isSystemUser() {
                    return this.systemUser;
                }

                public boolean isPrivileged() {
                    return this.privileged;
                }

                public boolean isInternalUser() {
                    return this.internalUser;
                }

                public List<String> getRoles() {
                    return this.roles;
                }

                public List<String> getFeatures() {
                    return this.features;
                }

                public Map<String, List<String>> getAttributes() {
                    return this.attributes;
                }

                @Deprecated
                public List<String> getUnrestricted() {
                    return this.unrestricted;
                }

                public Map<String, Object> getAdditional() {
                    return this.additional;
                }

                public void setId(String id) {
                    this.id = id;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setPassword(String password) {
                    this.password = password;
                }

                public void setTenant(String tenant) {
                    this.tenant = tenant;
                }

                public void setSystemUser(boolean systemUser) {
                    this.systemUser = systemUser;
                }

                public void setPrivileged(boolean privileged) {
                    this.privileged = privileged;
                }

                public void setInternalUser(boolean internalUser) {
                    this.internalUser = internalUser;
                }

                public void setRoles(List<String> roles) {
                    this.roles = roles;
                }

                public void setFeatures(List<String> features) {
                    this.features = features;
                }

                public void setAttributes(Map<String, List<String>> attributes) {
                    this.attributes = attributes;
                }

                @Deprecated
                public void setUnrestricted(List<String> unrestricted) {
                    this.unrestricted = unrestricted;
                }

                public void setAdditional(Map<String, Object> additional) {
                    this.additional = additional;
                }
            }

            public static class Tenant {
                private String name;
                private List<String> features = new ArrayList<String>();

                public String getName() {
                    return this.name;
                }

                public List<String> getFeatures() {
                    return this.features;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setFeatures(List<String> features) {
                    this.features = features;
                }
            }
        }
    }

    public static class Servlet
    extends Enabled {
        private String path;

        public Servlet(String path, boolean enabled) {
            super(enabled);
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    public static class ODataV4 {
        private Servlet endpoint = new Servlet("/odata/v4", true);
        private boolean contextAbsoluteUrl = false;
        private String edmxPath = "edmx/v4";
        private Serializer serializer = new Serializer();
        private Enabled cdsToEdm = new Enabled(false);
        private Batch batch = new Batch();

        public Servlet getEndpoint() {
            return this.endpoint;
        }

        public boolean isContextAbsoluteUrl() {
            return this.contextAbsoluteUrl;
        }

        public String getEdmxPath() {
            return this.edmxPath;
        }

        public Serializer getSerializer() {
            return this.serializer;
        }

        public Enabled getCdsToEdm() {
            return this.cdsToEdm;
        }

        public Batch getBatch() {
            return this.batch;
        }

        public void setEndpoint(Servlet endpoint) {
            this.endpoint = endpoint;
        }

        public void setContextAbsoluteUrl(boolean contextAbsoluteUrl) {
            this.contextAbsoluteUrl = contextAbsoluteUrl;
        }

        public void setEdmxPath(String edmxPath) {
            this.edmxPath = edmxPath;
        }

        public void setSerializer(Serializer serializer) {
            this.serializer = serializer;
        }

        public void setCdsToEdm(Enabled cdsToEdm) {
            this.cdsToEdm = cdsToEdm;
        }

        public void setBatch(Batch batch) {
            this.batch = batch;
        }

        public static class Serializer
        extends Enabled {
            private boolean buffered;

            public Serializer() {
                super(true);
            }

            public boolean isBuffered() {
                return this.buffered;
            }

            public void setBuffered(boolean buffered) {
                this.buffered = buffered;
            }
        }

        public static class Batch {
            private long maxRequests = -1L;

            public long getMaxRequests() {
                return this.maxRequests;
            }

            public void setMaxRequests(long maxRequests) {
                this.maxRequests = maxRequests;
            }
        }
    }

    public static class ODataV2 {
        private Servlet endpoint = new Servlet("/odata/v2", true);
        private String edmxPath = "edmx/v2";
        private boolean caseSensitiveFilter = true;
        private Batch batch = new Batch();

        public Servlet getEndpoint() {
            return this.endpoint;
        }

        public String getEdmxPath() {
            return this.edmxPath;
        }

        public boolean isCaseSensitiveFilter() {
            return this.caseSensitiveFilter;
        }

        public Batch getBatch() {
            return this.batch;
        }

        public void setEndpoint(Servlet endpoint) {
            this.endpoint = endpoint;
        }

        public void setEdmxPath(String edmxPath) {
            this.edmxPath = edmxPath;
        }

        public void setCaseSensitiveFilter(boolean caseSensitiveFilter) {
            this.caseSensitiveFilter = caseSensitiveFilter;
        }

        public void setBatch(Batch batch) {
            this.batch = batch;
        }

        public static class Batch {
            private long maxRequests = -1L;

            public long getMaxRequests() {
                return this.maxRequests;
            }

            public void setMaxRequests(long maxRequests) {
                this.maxRequests = maxRequests;
            }
        }
    }

    public static class Hcql {
        private Servlet endpoint = new Servlet("/hcql", true);

        public Servlet getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(Servlet endpoint) {
            this.endpoint = endpoint;
        }
    }

    public static class Messaging {
        private MessagingWebhooks webhooks = new MessagingWebhooks();
        private boolean resetQueues = false;
        private List<Composite.CompositeServiceConfig.Route> routes = new ArrayList<Composite.CompositeServiceConfig.Route>();
        private Map<String, MessagingServiceConfig> services = new HashMap<String, MessagingServiceConfig>();

        public Map<String, MessagingServiceConfig> getServices() {
            this.services.forEach((k, v) -> {
                if (v.getName() == null || v.getName().trim().isEmpty()) {
                    v.setName((String)k);
                }
            });
            return this.services;
        }

        public MessagingServiceConfig getService(String name) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getName(), name)).findFirst().orElse(new MessagingServiceConfig(name));
        }

        public List<MessagingServiceConfig> getServicesByKind(String kind) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getKind(), kind)).collect(Collectors.toList());
        }

        public List<MessagingServiceConfig> getServicesByBinding(String binding) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getBinding(), binding) || s.getBinding() == null && Objects.equals(s.getName(), binding)).collect(Collectors.toList());
        }

        public MessagingWebhooks getWebhooks() {
            return this.webhooks;
        }

        public boolean isResetQueues() {
            return this.resetQueues;
        }

        public List<Composite.CompositeServiceConfig.Route> getRoutes() {
            return this.routes;
        }

        public void setWebhooks(MessagingWebhooks webhooks) {
            this.webhooks = webhooks;
        }

        public void setResetQueues(boolean resetQueues) {
            this.resetQueues = resetQueues;
        }

        public void setRoutes(List<Composite.CompositeServiceConfig.Route> routes) {
            this.routes = routes;
        }

        public void setServices(Map<String, MessagingServiceConfig> services) {
            this.services = services;
        }

        public static class MessagingWebhooks
        extends Enabled {
            private String url;

            public MessagingWebhooks() {
                super(true);
            }

            public String getUrl() {
                return this.url;
            }

            public void setUrl(String url) {
                this.url = url;
            }
        }

        public static class MessagingServiceConfig
        extends Enabled {
            private String name;
            private String kind;
            private String binding;
            private String subscribePrefix;
            private String publishPrefix;
            private String format;
            private boolean structured = false;
            private Connection connection = new Connection();
            private Queue queue = new Queue();
            private Outbox outbox = new Outbox();

            public MessagingServiceConfig() {
                super(true);
            }

            public MessagingServiceConfig(String name) {
                super(true);
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public String getKind() {
                return this.kind;
            }

            public String getBinding() {
                return this.binding;
            }

            public String getSubscribePrefix() {
                return this.subscribePrefix;
            }

            public String getPublishPrefix() {
                return this.publishPrefix;
            }

            public String getFormat() {
                return this.format;
            }

            public boolean isStructured() {
                return this.structured;
            }

            public Connection getConnection() {
                return this.connection;
            }

            public Queue getQueue() {
                return this.queue;
            }

            public Outbox getOutbox() {
                return this.outbox;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setKind(String kind) {
                this.kind = kind;
            }

            public void setBinding(String binding) {
                this.binding = binding;
            }

            public void setSubscribePrefix(String subscribePrefix) {
                this.subscribePrefix = subscribePrefix;
            }

            public void setPublishPrefix(String publishPrefix) {
                this.publishPrefix = publishPrefix;
            }

            public void setFormat(String format) {
                this.format = format;
            }

            public void setStructured(boolean structured) {
                this.structured = structured;
            }

            public void setConnection(Connection connection) {
                this.connection = connection;
            }

            public void setQueue(Queue queue) {
                this.queue = queue;
            }

            public void setOutbox(Outbox outbox) {
                this.outbox = outbox;
            }

            public static class Connection {
                private boolean dedicated = false;
                private Map<String, String> properties = new HashMap<String, String>();
                private ConnectionPool connectionPool = new ConnectionPool();

                public boolean isDedicated() {
                    return this.dedicated;
                }

                public Map<String, String> getProperties() {
                    return this.properties;
                }

                public ConnectionPool getConnectionPool() {
                    return this.connectionPool;
                }

                public void setDedicated(boolean dedicated) {
                    this.dedicated = dedicated;
                }

                public void setProperties(Map<String, String> properties) {
                    this.properties = properties;
                }

                public void setConnectionPool(ConnectionPool connectionPool) {
                    this.connectionPool = connectionPool;
                }
            }

            public static class Queue {
                private String name;
                private Map<String, String> config = new HashMap<String, String>();
                private List<String> subscriptions = new ArrayList<String>();
                private boolean forceListening = false;

                public String getName() {
                    return this.name;
                }

                public Map<String, String> getConfig() {
                    return this.config;
                }

                public List<String> getSubscriptions() {
                    return this.subscriptions;
                }

                public boolean isForceListening() {
                    return this.forceListening;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setConfig(Map<String, String> config) {
                    this.config = config;
                }

                public void setSubscriptions(List<String> subscriptions) {
                    this.subscriptions = subscriptions;
                }

                public void setForceListening(boolean forceListening) {
                    this.forceListening = forceListening;
                }
            }

            public static class Outbox
            extends Enabled {
                private Enabled persistent = new Enabled(true);

                public Outbox() {
                    super(true);
                }

                public Enabled getPersistent() {
                    return this.persistent;
                }

                public void setPersistent(Enabled persistent) {
                    this.persistent = persistent;
                }
            }
        }
    }

    public static class MultiTenancy {
        private Servlet endpoint = new Servlet("/mt/v1.0/subscriptions", true);
        private SubscriptionManager subscriptionManager = new SubscriptionManager();
        private DataSource dataSource = new DataSource();
        private ServiceManager serviceManager = new ServiceManager();
        private Security security = new Security();
        private Deployer deployer = new Deployer();
        private Sidecar sidecar = new Sidecar();
        private AppUi appUi = new AppUi();
        private HealthCheck healthCheck = new HealthCheck();
        private Liquibase liquibase = new Liquibase();
        private ProvisioningService provisioning = new ProvisioningService();
        private Enabled mtxs = new Enabled(false);
        private Mock mock = new Mock();
        private Enabled compatibility = new Enabled(true);
        private String componentScan;

        public Servlet getEndpoint() {
            return this.endpoint;
        }

        public SubscriptionManager getSubscriptionManager() {
            return this.subscriptionManager;
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public ServiceManager getServiceManager() {
            return this.serviceManager;
        }

        public Security getSecurity() {
            return this.security;
        }

        public Deployer getDeployer() {
            return this.deployer;
        }

        public Sidecar getSidecar() {
            return this.sidecar;
        }

        public AppUi getAppUi() {
            return this.appUi;
        }

        public HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        public Liquibase getLiquibase() {
            return this.liquibase;
        }

        public ProvisioningService getProvisioning() {
            return this.provisioning;
        }

        public Enabled getMtxs() {
            return this.mtxs;
        }

        public Mock getMock() {
            return this.mock;
        }

        public Enabled getCompatibility() {
            return this.compatibility;
        }

        public String getComponentScan() {
            return this.componentScan;
        }

        public void setEndpoint(Servlet endpoint) {
            this.endpoint = endpoint;
        }

        public void setSubscriptionManager(SubscriptionManager subscriptionManager) {
            this.subscriptionManager = subscriptionManager;
        }

        public void setDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public void setServiceManager(ServiceManager serviceManager) {
            this.serviceManager = serviceManager;
        }

        public void setSecurity(Security security) {
            this.security = security;
        }

        public void setDeployer(Deployer deployer) {
            this.deployer = deployer;
        }

        public void setSidecar(Sidecar sidecar) {
            this.sidecar = sidecar;
        }

        public void setAppUi(AppUi appUi) {
            this.appUi = appUi;
        }

        public void setHealthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
        }

        public void setLiquibase(Liquibase liquibase) {
            this.liquibase = liquibase;
        }

        public void setProvisioning(ProvisioningService provisioning) {
            this.provisioning = provisioning;
        }

        public void setMtxs(Enabled mtxs) {
            this.mtxs = mtxs;
        }

        public void setMock(Mock mock) {
            this.mock = mock;
        }

        public void setCompatibility(Enabled compatibility) {
            this.compatibility = compatibility;
        }

        public void setComponentScan(String componentScan) {
            this.componentScan = componentScan;
        }

        public static class SubscriptionManager {
            private Servlet endpoint = new Servlet("/mt/sms/subscriptions", true);
            private String clientCertificateHeader = "X-Forwarded-Client-Cert";

            public Servlet getEndpoint() {
                return this.endpoint;
            }

            public String getClientCertificateHeader() {
                return this.clientCertificateHeader;
            }

            public void setEndpoint(Servlet endpoint) {
                this.endpoint = endpoint;
            }

            public void setClientCertificateHeader(String clientCertificateHeader) {
                this.clientCertificateHeader = clientCertificateHeader;
            }
        }

        public static class DataSource {
            private String pool = "hikari";
            private Enabled combinePools = new Enabled(false);
            private String hanaEncryptionMode;

            public String getPool() {
                return this.pool;
            }

            public Enabled getCombinePools() {
                return this.combinePools;
            }

            public String getHanaEncryptionMode() {
                return this.hanaEncryptionMode;
            }

            public void setPool(String pool) {
                this.pool = pool;
            }

            public void setCombinePools(Enabled combinePools) {
                this.combinePools = combinePools;
            }

            public void setHanaEncryptionMode(String hanaEncryptionMode) {
                this.hanaEncryptionMode = hanaEncryptionMode;
            }
        }

        public static class ServiceManager {
            private int timeout = 3600;
            private Duration cacheRefreshInterval = Duration.ofMinutes(2L);

            public int getTimeout() {
                return this.timeout;
            }

            public Duration getCacheRefreshInterval() {
                return this.cacheRefreshInterval;
            }

            public void setTimeout(int timeout) {
                this.timeout = timeout;
            }

            public void setCacheRefreshInterval(Duration cacheRefreshInterval) {
                this.cacheRefreshInterval = cacheRefreshInterval;
            }
        }

        public static class Security {
            private String subscriptionScope = "mtcallback";
            @Deprecated
            private String deploymentScope = "mtdeployment";

            public String getSubscriptionScope() {
                return this.subscriptionScope;
            }

            @Deprecated
            public String getDeploymentScope() {
                return this.deploymentScope;
            }

            public void setSubscriptionScope(String subscriptionScope) {
                this.subscriptionScope = subscriptionScope;
            }

            @Deprecated
            public void setDeploymentScope(String deploymentScope) {
                this.deploymentScope = deploymentScope;
            }
        }

        public static class Deployer {
            private String url;
            private String user;
            private String password;
            private Duration asyncTimeout = Duration.ofMinutes(10L);

            public String getUrl() {
                return this.url;
            }

            public String getUser() {
                return this.user;
            }

            public String getPassword() {
                return this.password;
            }

            public Duration getAsyncTimeout() {
                return this.asyncTimeout;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public void setUser(String user) {
                this.user = user;
            }

            public void setPassword(String password) {
                this.password = password;
            }

            public void setAsyncTimeout(Duration asyncTimeout) {
                this.asyncTimeout = asyncTimeout;
            }
        }

        public static class Sidecar {
            private Cache cache = new Cache();
            private String url;
            private Duration pollingInterval = Duration.ofSeconds(5L);
            private Duration pollingTimeout = Duration.ofMinutes(20L);

            public Cache getCache() {
                return this.cache;
            }

            public String getUrl() {
                return this.url;
            }

            public Duration getPollingInterval() {
                return this.pollingInterval;
            }

            public Duration getPollingTimeout() {
                return this.pollingTimeout;
            }

            public void setCache(Cache cache) {
                this.cache = cache;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public void setPollingInterval(Duration pollingInterval) {
                this.pollingInterval = pollingInterval;
            }

            public void setPollingTimeout(Duration pollingTimeout) {
                this.pollingTimeout = pollingTimeout;
            }

            public static class Cache {
                private int maxSize = 20;
                private int expirationTime = 600;
                private int refreshTime = 60;
                private boolean refreshEager = true;

                public int getMaxSize() {
                    return this.maxSize;
                }

                public int getExpirationTime() {
                    return this.expirationTime;
                }

                public int getRefreshTime() {
                    return this.refreshTime;
                }

                public boolean isRefreshEager() {
                    return this.refreshEager;
                }

                public void setMaxSize(int maxSize) {
                    this.maxSize = maxSize;
                }

                public void setExpirationTime(int expirationTime) {
                    this.expirationTime = expirationTime;
                }

                public void setRefreshTime(int refreshTime) {
                    this.refreshTime = refreshTime;
                }

                public void setRefreshEager(boolean refreshEager) {
                    this.refreshEager = refreshEager;
                }
            }
        }

        public static class AppUi {
            private String url;
            private String tenantSeparator;

            public String getUrl() {
                return this.url;
            }

            public String getTenantSeparator() {
                return this.tenantSeparator;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public void setTenantSeparator(String tenantSeparator) {
                this.tenantSeparator = tenantSeparator;
            }
        }

        public static class HealthCheck
        extends Enabled {
            private String healthCheckStatement = "";
            private Duration interval = Duration.ofSeconds(10L);

            public HealthCheck() {
                super(true);
            }

            @Deprecated
            public long getIntervalMillis() {
                return this.interval.toMillis();
            }

            @Deprecated
            public void setIntervalMillis(long millis) {
                this.interval = Duration.ofMillis(millis);
            }

            public String getHealthCheckStatement() {
                return this.healthCheckStatement;
            }

            public Duration getInterval() {
                return this.interval;
            }

            public void setHealthCheckStatement(String healthCheckStatement) {
                this.healthCheckStatement = healthCheckStatement;
            }

            public void setInterval(Duration interval) {
                this.interval = interval;
            }
        }

        public static class Liquibase {
            private String changeLog = "/db/changelog/db.changelog-master.yaml";
            private String contexts;

            public String getChangeLog() {
                return this.changeLog;
            }

            public String getContexts() {
                return this.contexts;
            }

            public void setChangeLog(String changeLog) {
                this.changeLog = changeLog;
            }

            public void setContexts(String contexts) {
                this.contexts = contexts;
            }
        }

        public static class ProvisioningService {
            private String url;
            private Duration pollingInterval = Duration.ofSeconds(5L);
            private Duration pollingTimeout = Duration.ofMinutes(10L);

            public String getUrl() {
                return this.url;
            }

            public Duration getPollingInterval() {
                return this.pollingInterval;
            }

            public Duration getPollingTimeout() {
                return this.pollingTimeout;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public void setPollingInterval(Duration pollingInterval) {
                this.pollingInterval = pollingInterval;
            }

            public void setPollingTimeout(Duration pollingTimeout) {
                this.pollingTimeout = pollingTimeout;
            }
        }

        public static class Mock
        extends Enabled {
            private String sqliteDirectory;

            public Mock() {
                super(true);
            }

            public String getSqliteDirectory() {
                return this.sqliteDirectory;
            }

            public void setSqliteDirectory(String sqliteDirectory) {
                this.sqliteDirectory = sqliteDirectory;
            }
        }
    }

    public static class Persistence {
        private Map<String, PersistenceServiceConfig> services = new HashMap<String, PersistenceServiceConfig>();

        public Map<String, PersistenceServiceConfig> getServices() {
            this.services.forEach((k, v) -> {
                if (v.getName() == null || v.getName().trim().isEmpty()) {
                    v.setName((String)k);
                }
            });
            return this.services;
        }

        public void setServices(Map<String, PersistenceServiceConfig> services) {
            this.services = services;
        }

        public static class PersistenceServiceConfig
        extends Enabled {
            private String name;
            private String binding;
            private String dataSource;
            private String transactionManager;

            public PersistenceServiceConfig() {
                super(true);
            }

            public PersistenceServiceConfig(String name) {
                this();
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public String getBinding() {
                return this.binding;
            }

            public String getDataSource() {
                return this.dataSource;
            }

            public String getTransactionManager() {
                return this.transactionManager;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setBinding(String binding) {
                this.binding = binding;
            }

            public void setDataSource(String dataSource) {
                this.dataSource = dataSource;
            }

            public void setTransactionManager(String transactionManager) {
                this.transactionManager = transactionManager;
            }
        }
    }

    public static class Application {
        private Map<String, ApplicationServiceConfig> services = new HashMap<String, ApplicationServiceConfig>();

        public Map<String, ApplicationServiceConfig> getServices() {
            this.services.forEach((k, v) -> {
                if (v.getName() == null || v.getName().trim().isEmpty()) {
                    v.setName((String)k);
                }
            });
            return this.services;
        }

        public ApplicationServiceConfig getService(String name) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getName(), name)).findFirst().orElse(new ApplicationServiceConfig(name));
        }

        public List<ApplicationServiceConfig> getServicesByModel(String model) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getModel(), model) || s.getModel() == null && Objects.equals(s.getName(), model)).collect(Collectors.toList());
        }

        public void setServices(Map<String, ApplicationServiceConfig> services) {
            this.services = services;
        }

        public static class ApplicationServiceConfig {
            private String name;
            private String model;
            private Serve serve = new Serve();

            public ApplicationServiceConfig() {
            }

            public ApplicationServiceConfig(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public String getModel() {
                return this.model;
            }

            public Serve getServe() {
                return this.serve;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setModel(String model) {
                this.model = model;
            }

            public void setServe(Serve serve) {
                this.serve = serve;
            }

            public static class Serve {
                private boolean ignore;
                private String path;
                private List<String> protocols = new ArrayList<String>();
                private List<Endpoint> endpoints = new ArrayList<Endpoint>();

                public boolean isIgnore() {
                    return this.ignore;
                }

                public String getPath() {
                    return this.path;
                }

                public List<String> getProtocols() {
                    return this.protocols;
                }

                public List<Endpoint> getEndpoints() {
                    return this.endpoints;
                }

                public void setIgnore(boolean ignore) {
                    this.ignore = ignore;
                }

                public void setPath(String path) {
                    this.path = path;
                }

                public void setProtocols(List<String> protocols) {
                    this.protocols = protocols;
                }

                public void setEndpoints(List<Endpoint> endpoints) {
                    this.endpoints = endpoints;
                }

                public static class Endpoint {
                    private String path;
                    private String protocol;

                    public String getPath() {
                        return this.path;
                    }

                    public String getProtocol() {
                        return this.protocol;
                    }

                    public void setPath(String path) {
                        this.path = path;
                    }

                    public void setProtocol(String protocol) {
                        this.protocol = protocol;
                    }
                }
            }
        }
    }

    public static class Remote {
        private Map<String, RemoteServiceConfig> services = new HashMap<String, RemoteServiceConfig>();

        public Map<String, RemoteServiceConfig> getServices() {
            this.services.forEach((k, v) -> {
                if (v.getName() == null || v.getName().trim().isEmpty()) {
                    v.setName((String)k);
                }
            });
            return this.services;
        }

        public RemoteServiceConfig getService(String name) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getName(), name)).findFirst().orElse(new RemoteServiceConfig(name));
        }

        public List<RemoteServiceConfig> getServicesByModel(String model) {
            return this.getServices().values().stream().filter(s -> Objects.equals(s.getModel(), model) || s.getModel() == null && Objects.equals(s.getName(), model)).collect(Collectors.toList());
        }

        public void setServices(Map<String, RemoteServiceConfig> services) {
            this.services = services;
        }

        public static class RemoteServiceConfig {
            private String name;
            private String model;
            private Destination destination = new Destination();

            public RemoteServiceConfig() {
            }

            public RemoteServiceConfig(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public String getModel() {
                return this.model;
            }

            public Destination getDestination() {
                return this.destination;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setModel(String model) {
                this.model = model;
            }

            public void setDestination(Destination destination) {
                this.destination = destination;
            }

            public static class Destination {
                public static final String ODATA_V2_TYPE = "odata-v2";
                public static final String ODATA_V4_TYPE = "odata-v4";
                public static final String HCQL_TYPE = "hcql";
                private String type = "odata-v4";
                private String name;
                private String suffix;
                private String service;
                private Map<String, Object> properties = new HashMap<String, Object>();
                private Map<String, String> headers = new HashMap<String, String>();
                private Map<String, String> queries = new HashMap<String, String>();
                private String retrievalStrategy;
                private String tokenExchangeStrategy;

                public String getType() {
                    return this.type;
                }

                public String getName() {
                    return this.name;
                }

                public String getSuffix() {
                    return this.suffix;
                }

                public String getService() {
                    return this.service;
                }

                public Map<String, Object> getProperties() {
                    return this.properties;
                }

                public Map<String, String> getHeaders() {
                    return this.headers;
                }

                public Map<String, String> getQueries() {
                    return this.queries;
                }

                public String getRetrievalStrategy() {
                    return this.retrievalStrategy;
                }

                public String getTokenExchangeStrategy() {
                    return this.tokenExchangeStrategy;
                }

                public void setType(String type) {
                    this.type = type;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setSuffix(String suffix) {
                    this.suffix = suffix;
                }

                public void setService(String service) {
                    this.service = service;
                }

                public void setProperties(Map<String, Object> properties) {
                    this.properties = properties;
                }

                public void setHeaders(Map<String, String> headers) {
                    this.headers = headers;
                }

                public void setQueries(Map<String, String> queries) {
                    this.queries = queries;
                }

                public void setRetrievalStrategy(String retrievalStrategy) {
                    this.retrievalStrategy = retrievalStrategy;
                }

                public void setTokenExchangeStrategy(String tokenExchangeStrategy) {
                    this.tokenExchangeStrategy = tokenExchangeStrategy;
                }
            }
        }
    }

    public static class Locales {
        private Normalization normalization = new Normalization();

        public Normalization getNormalization() {
            return this.normalization;
        }

        public void setNormalization(Normalization normalization) {
            this.normalization = normalization;
        }

        public static class Normalization {
            private boolean defaults = true;
            private List<String> includeList = new ArrayList<String>();

            public boolean isDefaults() {
                return this.defaults;
            }

            public List<String> getIncludeList() {
                return this.includeList;
            }

            public void setDefaults(boolean defaults) {
                this.defaults = defaults;
            }

            public void setIncludeList(List<String> includeList) {
                this.includeList = includeList;
            }
        }
    }

    public static class Errors {
        private Enabled stackMessages = new Enabled(true);
        private boolean extended = false;
        private boolean combined = true;

        public Enabled getStackMessages() {
            return this.stackMessages;
        }

        public boolean isExtended() {
            return this.extended;
        }

        public boolean isCombined() {
            return this.combined;
        }

        public void setStackMessages(Enabled stackMessages) {
            this.stackMessages = stackMessages;
        }

        public void setExtended(boolean extended) {
            this.extended = extended;
        }

        public void setCombined(boolean combined) {
            this.combined = combined;
        }
    }

    public static class Drafts {
        private Duration cancellationTimeout = Duration.ofMinutes(15L);
        private Duration deletionTimeout = Duration.ofDays(30L);
        private String persistence = "joint";
        private GC gc = new GC();

        public Duration getCancellationTimeout() {
            return this.cancellationTimeout;
        }

        public Duration getDeletionTimeout() {
            return this.deletionTimeout;
        }

        public String getPersistence() {
            return this.persistence;
        }

        public GC getGc() {
            return this.gc;
        }

        public void setCancellationTimeout(Duration cancellationTimeout) {
            this.cancellationTimeout = cancellationTimeout;
        }

        public void setDeletionTimeout(Duration deletionTimeout) {
            this.deletionTimeout = deletionTimeout;
        }

        public void setPersistence(String persistence) {
            this.persistence = persistence;
        }

        public void setGc(GC gc) {
            this.gc = gc;
        }

        public static class GC
        extends Enabled {
            private Duration interval = Duration.ofHours(6L);

            public GC() {
                super(true);
            }

            public Duration getInterval() {
                return this.interval;
            }

            public void setInterval(Duration interval) {
                this.interval = interval;
            }
        }
    }

    public static class Query {
        private Limit limit = new Limit();
        private Enabled implicitSorting = new Enabled(true);
        private Validation validation = new Validation();

        public Limit getLimit() {
            return this.limit;
        }

        public Enabled getImplicitSorting() {
            return this.implicitSorting;
        }

        public Validation getValidation() {
            return this.validation;
        }

        public void setLimit(Limit limit) {
            this.limit = limit;
        }

        public void setImplicitSorting(Enabled implicitSorting) {
            this.implicitSorting = implicitSorting;
        }

        public void setValidation(Validation validation) {
            this.validation = validation;
        }

        public static class Limit {
            private int _default = 0;
            private int max = 1000;
            private Enabled reliablePaging = new Enabled(false);

            public int getDefault() {
                return this._default;
            }

            public void setDefault(int _default) {
                this._default = _default;
            }

            public int getMax() {
                return this.max;
            }

            public void setMax(int max) {
                this.max = max;
            }

            public Enabled getReliablePaging() {
                return this.reliablePaging;
            }

            public void setReliablePaging(Enabled reliablePaging) {
                this.reliablePaging = reliablePaging;
            }
        }

        public static class Validation {
            @Deprecated
            private Enabled parameters = new Enabled(true);

            @Deprecated
            public Enabled getParameters() {
                return this.parameters;
            }

            @Deprecated
            public void setParameters(Enabled parameters) {
                this.parameters = parameters;
            }
        }
    }

    public static class Sql {
        @Deprecated
        private List<String> supportedLocales = Arrays.asList(new String[0]);
        private int maxBatchSize = 1000;
        private boolean ignoreVirtualElements = true;
        private String collate = "strings";
        private Hana hana = new Hana();
        private Search search = new Search();

        @Deprecated
        public List<String> getSupportedLocales() {
            return this.supportedLocales;
        }

        public int getMaxBatchSize() {
            return this.maxBatchSize;
        }

        public boolean isIgnoreVirtualElements() {
            return this.ignoreVirtualElements;
        }

        public String getCollate() {
            return this.collate;
        }

        public Hana getHana() {
            return this.hana;
        }

        public Search getSearch() {
            return this.search;
        }

        @Deprecated
        public void setSupportedLocales(List<String> supportedLocales) {
            this.supportedLocales = supportedLocales;
        }

        public void setMaxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        public void setIgnoreVirtualElements(boolean ignoreVirtualElements) {
            this.ignoreVirtualElements = ignoreVirtualElements;
        }

        public void setCollate(String collate) {
            this.collate = collate;
        }

        public void setHana(Hana hana) {
            this.hana = hana;
        }

        public void setSearch(Search search) {
            this.search = search;
        }

        public static class Hana {
            private boolean ignoreLocale = false;
            private String optimizationMode = "legacy";
            private Docstore docstore = new Docstore();

            public boolean isIgnoreLocale() {
                return this.ignoreLocale;
            }

            public String getOptimizationMode() {
                return this.optimizationMode;
            }

            public Docstore getDocstore() {
                return this.docstore;
            }

            public void setIgnoreLocale(boolean ignoreLocale) {
                this.ignoreLocale = ignoreLocale;
            }

            public void setOptimizationMode(String optimizationMode) {
                this.optimizationMode = optimizationMode;
            }

            public void setDocstore(Docstore docstore) {
                this.docstore = docstore;
            }

            public static class Docstore
            extends Enabled {
                public Docstore() {
                    super(false);
                }
            }
        }

        public static class Search {
            private boolean useLocalizedView;

            public boolean isUseLocalizedView() {
                return this.useLocalizedView;
            }

            public void setUseLocalizedView(boolean useLocalizedView) {
                this.useLocalizedView = useLocalizedView;
            }
        }
    }

    public static class AuditLog {
        private V2 v2 = new V2();
        private PersonalData personalData = new PersonalData();
        private Outbox outbox = new Outbox();
        private StandardEvents standardEvents = new StandardEvents();
        private ConnectionPool connectionPool = new ConnectionPool();

        public V2 getV2() {
            return this.v2;
        }

        public PersonalData getPersonalData() {
            return this.personalData;
        }

        public Outbox getOutbox() {
            return this.outbox;
        }

        public StandardEvents getStandardEvents() {
            return this.standardEvents;
        }

        public ConnectionPool getConnectionPool() {
            return this.connectionPool;
        }

        public void setV2(V2 v2) {
            this.v2 = v2;
        }

        public void setPersonalData(PersonalData personalData) {
            this.personalData = personalData;
        }

        public void setOutbox(Outbox outbox) {
            this.outbox = outbox;
        }

        public void setStandardEvents(StandardEvents standardEvents) {
            this.standardEvents = standardEvents;
        }

        public void setConnectionPool(ConnectionPool connectionPool) {
            this.connectionPool = connectionPool;
        }

        public static class V2
        extends Enabled {
            private boolean useLogonName = false;

            public V2() {
                super(true);
            }

            public boolean isUseLogonName() {
                return this.useLogonName;
            }

            public void setUseLogonName(boolean useLogonName) {
                this.useLogonName = useLogonName;
            }
        }

        public static class PersonalData
        extends Enabled {
            private boolean throwOnMissingDataSubject = false;
            private Enabled logRead = new Enabled(true);
            private Enabled logInsert = new Enabled(true);
            private Enabled logDelete = new Enabled(true);
            private Enabled logUpdate = new Enabled(true);

            public PersonalData() {
                super(true);
            }

            public boolean isThrowOnMissingDataSubject() {
                return this.throwOnMissingDataSubject;
            }

            public Enabled getLogRead() {
                return this.logRead;
            }

            public Enabled getLogInsert() {
                return this.logInsert;
            }

            public Enabled getLogDelete() {
                return this.logDelete;
            }

            public Enabled getLogUpdate() {
                return this.logUpdate;
            }

            public void setThrowOnMissingDataSubject(boolean throwOnMissingDataSubject) {
                this.throwOnMissingDataSubject = throwOnMissingDataSubject;
            }

            public void setLogRead(Enabled logRead) {
                this.logRead = logRead;
            }

            public void setLogInsert(Enabled logInsert) {
                this.logInsert = logInsert;
            }

            public void setLogDelete(Enabled logDelete) {
                this.logDelete = logDelete;
            }

            public void setLogUpdate(Enabled logUpdate) {
                this.logUpdate = logUpdate;
            }
        }

        public static class Outbox
        extends Enabled {
            private Enabled persistent = new Enabled(true);

            public Outbox() {
                super(true);
            }

            public Enabled getPersistent() {
                return this.persistent;
            }

            public void setPersistent(Enabled persistent) {
                this.persistent = persistent;
            }
        }

        public static class StandardEvents
        extends Enabled {
            private Enabled tenantOnboardingEvent = new Enabled(false);
            private Enabled tenantOffboardingEvent = new Enabled(false);
            private Enabled unauthorizedRequestEvent = new Enabled(true);

            public StandardEvents() {
                super(false);
            }

            public Enabled getTenantOnboardingEvent() {
                return this.tenantOnboardingEvent;
            }

            public Enabled getTenantOffboardingEvent() {
                return this.tenantOffboardingEvent;
            }

            public Enabled getUnauthorizedRequestEvent() {
                return this.unauthorizedRequestEvent;
            }

            public void setTenantOnboardingEvent(Enabled tenantOnboardingEvent) {
                this.tenantOnboardingEvent = tenantOnboardingEvent;
            }

            public void setTenantOffboardingEvent(Enabled tenantOffboardingEvent) {
                this.tenantOffboardingEvent = tenantOffboardingEvent;
            }

            public void setUnauthorizedRequestEvent(Enabled unauthorizedRequestEvent) {
                this.unauthorizedRequestEvent = unauthorizedRequestEvent;
            }
        }
    }

    public static class Outbox {
        private InMemory inMemory = new InMemory();
        private Persistent persistent = new Persistent();

        public InMemory getInMemory() {
            return this.inMemory;
        }

        public Persistent getPersistent() {
            return this.persistent;
        }

        public void setInMemory(InMemory inMemory) {
            this.inMemory = inMemory;
        }

        public void setPersistent(Persistent persistent) {
            this.persistent = persistent;
        }

        public static class InMemory
        extends Enabled {
            private boolean emitDuringChangeSetContext = false;

            public InMemory() {
                super(true);
            }

            public boolean isEmitDuringChangeSetContext() {
                return this.emitDuringChangeSetContext;
            }

            public void setEmitDuringChangeSetContext(boolean emitDuringChangeSetContext) {
                this.emitDuringChangeSetContext = emitDuringChangeSetContext;
            }
        }

        public static class Persistent
        extends Enabled {
            private int maxAttempts = 10;
            private Duration emitTimeout = Duration.ofSeconds(10L);
            private int chunkSize = 10;
            private Duration maxPause = Duration.ofMinutes(10L);
            private Duration tenantsInfoRefreshInterval = Duration.ofMinutes(5L);
            private Enabled triggerSchedule = new Enabled(true);
            private Enabled providerTenant = new Enabled(true);
            private Enabled storeLastError = new Enabled(true);

            public Persistent() {
                super(true);
            }

            public int getMaxAttempts() {
                return this.maxAttempts;
            }

            public Duration getEmitTimeout() {
                return this.emitTimeout;
            }

            public int getChunkSize() {
                return this.chunkSize;
            }

            public Duration getMaxPause() {
                return this.maxPause;
            }

            public Duration getTenantsInfoRefreshInterval() {
                return this.tenantsInfoRefreshInterval;
            }

            public Enabled getTriggerSchedule() {
                return this.triggerSchedule;
            }

            public Enabled getProviderTenant() {
                return this.providerTenant;
            }

            public Enabled getStoreLastError() {
                return this.storeLastError;
            }

            public void setMaxAttempts(int maxAttempts) {
                this.maxAttempts = maxAttempts;
            }

            public void setEmitTimeout(Duration emitTimeout) {
                this.emitTimeout = emitTimeout;
            }

            public void setChunkSize(int chunkSize) {
                this.chunkSize = chunkSize;
            }

            public void setMaxPause(Duration maxPause) {
                this.maxPause = maxPause;
            }

            public void setTenantsInfoRefreshInterval(Duration tenantsInfoRefreshInterval) {
                this.tenantsInfoRefreshInterval = tenantsInfoRefreshInterval;
            }

            public void setTriggerSchedule(Enabled triggerSchedule) {
                this.triggerSchedule = triggerSchedule;
            }

            public void setProviderTenant(Enabled providerTenant) {
                this.providerTenant = providerTenant;
            }

            public void setStoreLastError(Enabled storeLastError) {
                this.storeLastError = storeLastError;
            }
        }
    }

    public static class CloudSdk {
        private Enabled executorDecorator = new Enabled(true);

        public Enabled getExecutorDecorator() {
            return this.executorDecorator;
        }

        public void setExecutorDecorator(Enabled executorDecorator) {
            this.executorDecorator = executorDecorator;
        }
    }

    public static class ConnectionPool {
        private Integer maxConnections = 200;
        private Integer maxConnectionsPerRoute = 20;
        private Duration timeout = Duration.ofMillis(60000L);
        private Enabled combinePools = new Enabled(true);

        public ConnectionPool() {
        }

        public ConnectionPool(Duration timeout, Integer maxConnectionsPerRoute, Integer maxConnections) {
            this.timeout = timeout;
            this.maxConnectionsPerRoute = maxConnectionsPerRoute;
            this.maxConnections = maxConnections;
        }

        public Integer getMaxConnections() {
            return this.maxConnections;
        }

        public Integer getMaxConnectionsPerRoute() {
            return this.maxConnectionsPerRoute;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public Enabled getCombinePools() {
            return this.combinePools;
        }

        public void setMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
        }

        public void setMaxConnectionsPerRoute(Integer maxConnectionsPerRoute) {
            this.maxConnectionsPerRoute = maxConnectionsPerRoute;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        public void setCombinePools(Enabled combinePools) {
            this.combinePools = combinePools;
        }
    }

    public static class Enabled {
        private Boolean enabled;

        public Enabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Composite {
        private Map<String, CompositeServiceConfig> services = new HashMap<String, CompositeServiceConfig>();

        public Map<String, CompositeServiceConfig> getServices() {
            this.services.forEach((k, v) -> {
                if (v.getName() == null || v.getName().trim().isEmpty()) {
                    v.setName((String)k);
                }
            });
            return this.services;
        }

        public void setServices(Map<String, CompositeServiceConfig> services) {
            this.services = services;
        }

        public static class CompositeServiceConfig {
            private String name;
            private List<Route> routes = new ArrayList<Route>();

            public CompositeServiceConfig(String name) {
                this.name = name;
            }

            public CompositeServiceConfig() {
            }

            public String getName() {
                return this.name;
            }

            public List<Route> getRoutes() {
                return this.routes;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setRoutes(List<Route> routes) {
                this.routes = routes;
            }

            public static class Route {
                private String service;
                private List<String> events = new ArrayList<String>();

                public String getService() {
                    return this.service;
                }

                public List<String> getEvents() {
                    return this.events;
                }

                public void setService(String service) {
                    this.service = service;
                }

                public void setEvents(List<String> events) {
                    this.events = events;
                }
            }
        }
    }
}

