/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services;

import java.util.stream.Stream;

/**
 * The {@link ServiceCatalog} provides access to the {@link Service} instances and their consumption API.
 */
public interface ServiceCatalog {

	/**
	 * Returns the {@link Service} with the specified name
	 * @param name the name of the {@link Service}
	 * @return the {@link Service}
	 */
	Service getService(String name);

	/**
	 * Returns the {@link Service} with the given type and name
	 * @param <S> the type of the {@link Service}
	 * @param serviceClass the class of the type S
	 * @param name the name of the {@link Service}
	 * @return the {@link Service} of type S
	 */
	<S extends Service> S getService(Class<S> serviceClass, String name);

	/**
	 * Returns all {@link Service} instances of a given type
	 * @param <S> the type of the {@link Service}
	 * @param serviceClass the class of the type S
	 * @return a stream of the {@link Service} instances of type S
	 */
	<S extends Service> Stream<S> getServices(Class<S> serviceClass);

	/**
	 * Returns all {@link Service} instances known to the {@link ServiceCatalog}
	 * @return a stream of all {@link Service} instances
	 */
	Stream<Service> getServices();
}
