/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services;

import com.sap.cds.services.handler.Handler;

public abstract class ServiceDelegator implements Service {

	private final Service service;

	protected ServiceDelegator(String name) {
		this.service = CoreFactory.INSTANCE.createService(name, this);
	}

	@Override
	public void before(String[] events, String[] entities, int order, Handler handler) {
		service.before(events, entities, order, handler);
	}

	@Override
	public void on(String[] events, String[] entities, int order, Handler handler) {
		service.on(events, entities, order, handler);
	}

	@Override
	public void after(String[] events, String[] entities, int order, Handler handler) {
		service.after(events, entities, order, handler);
	}

	@Override
	public void emit(EventContext context) {
		service.emit(context);
	}

	@Override
	public String getName() {
		return service.getName();
	}

	public Service getDelegatedService() {
		return service;
	}

}
