/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.application;

import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.application.ErrorResponseEventContext.ErrorResponse;

/**
 * The interface for the technical service which indicates application's lifecycle events.
 * Handlers of the {@link ApplicationLifecycleService} are notified on several application events.
 * E.g. {@code ApplicationLifecycleService#EVENT_APPLICATION_PREPARED} is sent when all application
 * objects have been initialized but the adapters hasn't been started yet. For Spring applications all beans
 * are available.
 */
public interface ApplicationLifecycleService extends Service {

	String DEFAULT_NAME = "ApplicationLifecycleService$Default";

	String EVENT_APPLICATION_PREPARED = "APPLICATION_PREPARED";
	String EVENT_APPLICATION_STOPPED = "APPLICATION_STOPPED";
	String EVENT_ERROR_RESPONSE = "ERROR_RESPONSE";

	/**
	 * Called when the application is fully initialized but not started yet.
	 */
	void applicationPrepared();

	/**
	 * Called when the application is stopped to allow termination of regular task threads.
	 * Please note, that it is not guaranteed that this event is fired, if the application is terminated.
	 *
	 * This event is especially useful in Spring contexts, to gracefully handle closing of an ApplicationContext.
	 */
	void applicationStopped();

	/**
	 * Called by protoocol adapters to control transformation of exception and messages into an error response.
	 * This event can be used to augment standard response.
	 *
	 * @param exception the {@link ServiceException}
	 * @return the {@link ErrorResponse}
	 */
	ErrorResponse errorResponse(ServiceException exception);

}
