package com.sap.cds.services.auditlog;

import java.util.Collection;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;

@CdsName("com.sap.cds.services.auditlog.Access")
public interface Access extends CdsData {
  String OBJECT = "object";

  String DATA_SUBJECT = "dataSubject";

  String ATTRIBUTES = "attributes";

  String ATTACHMENTS = "attachments";

  /**
   * The object where the accessed personal data that is being
   * audit logged is contained.
   */
  DataObject getDataObject();

  /**
   * The object where the accessed personal data that is being
   * audit logged is contained.
   */
  void setDataObject(DataObject object);

  /**
   * The data subject whom the accessed personal data that is
   * being audit logged belongs to.
   */
  DataSubject getDataSubject();

  /**
   * The data subject whom the accessed personal data that is
   * being audit logged belongs to.
   */
  void setDataSubject(DataSubject dataSubject);

  /**
   * The attributes that have been read
   */
  Collection<Attribute> getAttributes();

  /**
   * The attributes that have been read
   */
  void setAttributes(Collection<Attribute> attributes);

  /**
   * Attachments in case the event is triggered by the download
   * or display of some attachments or files.
   */
  Collection<Attachment> getAttachments();

  /**
   * Attachments in case the event is triggered by the download
   * or display of some attachments or files.
   */
  void setAttachments(Collection<Attachment> attachments);

  static Access create() {
    return Struct.create(Access.class);
  }
}
