package com.sap.cds.services.auditlog;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;

/**
 * Attachment name and identifier in case the audit log event
 * is triggered by the download or display of some attachments
 * or files
 */
@CdsName("com.sap.cds.services.auditlog.Attachment")
public interface Attachment extends CdsData {
  String ID = "id";

  String NAME = "name";

  /**
   * The attachment identifier.
   */
  String getId();

  /**
   * The attachment identifier.
   */
  void setId(String id);

  /**
   * The attachment name.
   */
  String getName();

  /**
   * The attachment name.
   */
  void setName(String name);

  static Attachment create() {
    return Struct.create(Attachment.class);
  }
}
