package com.sap.cds.services.auditlog;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;

/**
 * An attribute that has been modified
 */
@CdsName("com.sap.cds.services.auditlog.ChangedAttribute")
public interface ChangedAttribute extends CdsData {
  String NAME = "name";

  String OLD_VALUE = "oldValue";

  String NEW_VALUE = "newValue";

  /**
   * The attribute name.
   */
  String getName();

  /**
   * The attribute name.
   */
  void setName(String name);

  /**
   * The old value.
   */
  String getOldValue();

  /**
   * The old value.
   */
  void setOldValue(String oldValue);

  /**
   * The new value.
   */
  String getNewValue();

  /**
   * The new value.
   */
  void setNewValue(String newValue);

  static ChangedAttribute create() {
    return Struct.create(ChangedAttribute.class);
  }
}
