package com.sap.cds.services.auditlog;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;

/**
 * A generic key-value pair.
 */
@CdsName("com.sap.cds.services.auditlog.KeyValuePair")
public interface KeyValuePair extends CdsData {
  String KEY_NAME = "keyName";

  String VALUE = "value";

  /**
   * The key name.
   */
  String getKeyName();

  /**
   * The key name.
   */
  void setKeyName(String keyName);

  /**
   * The corresponding value.
   */
  String getValue();

  /**
   * The corresponding value.
   */
  void setValue(String value);

  static KeyValuePair create() {
    return Struct.create(KeyValuePair.class);
  }
}
