package com.sap.cds.services.auditlog;

import java.time.Instant;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

@EventName("securityLog")
public interface SecurityLogContext extends EventContext {
	String CDS_NAME = "securityLog";

	@Override
	AuditLogService getService();

	SecurityLog getData();

	void setData(SecurityLog event);

	Instant getCreatedAt();

	void setCreatedAt(Instant createdAt);

	static SecurityLogContext create() {
		return EventContext.create(SecurityLogContext.class, null);
	}
}
